/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.standalonegui.data.option.specific;

import de.tobiyas.racesandclasses.standalonegui.data.option.AbstractTraitConfigOption;
import de.tobiyas.racesandclasses.standalonegui.data.option.OptionType;
import de.tobiyas.racesandclasses.standalonegui.gui.MainFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TraitConfigStringOption
extends AbstractTraitConfigOption {
    private String value = "";

    public TraitConfigStringOption(String name, boolean optional) {
        super(OptionType.String, name, optional);
    }

    public TraitConfigStringOption(String name, boolean optional, String value) {
        this(name, optional);
        this.value = value;
    }

    @Override
    public boolean isAcceptable(String value) {
        if (super.isAcceptable(value)) {
            return true;
        }
        return true;
    }

    @Override
    public void valueSelected(String value) {
        this.value = value;
        this.needsSave = true;
        this.setCreated(true);
    }

    @Override
    public String getCurrentSelection() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + this.value;
    }

    @Override
    public void reset() {
        super.reset();
        this.value = "";
    }

    @Override
    public void addWithConfigOption(JPanel panel) {
        JPanel mainPanel = this.generateEmptyRightPanel();
        final JTextField text = new JTextField(this.value);
        text.setHorizontalAlignment(0);
        mainPanel.add(text);
        text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                String newValue = text.getText();
                TraitConfigStringOption.this.valueSelected(newValue);
                MainFrame.treeUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String newValue = text.getText();
                TraitConfigStringOption.this.valueSelected(newValue);
                MainFrame.treeUpdated();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                String newValue = text.getText();
                TraitConfigStringOption.this.valueSelected(newValue);
                MainFrame.treeUpdated();
            }
        });
        panel.add(mainPanel);
    }
}

