/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.standalonegui.data.option.specific;

import de.tobiyas.racesandclasses.standalonegui.data.option.AbstractTraitConfigOption;
import de.tobiyas.racesandclasses.standalonegui.data.option.OptionType;
import de.tobiyas.racesandclasses.standalonegui.gui.MainFrame;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.bukkit.Material;

public class TraitConfigMaterialOption
extends AbstractTraitConfigOption {
    private Material mat = Material.AIR;

    public TraitConfigMaterialOption(String name, boolean optional) {
        super(OptionType.Material, name, optional);
        this.options.clear();
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material mat = materialArray[n2];
            this.options.add(mat.name());
            ++n2;
        }
    }

    public TraitConfigMaterialOption(String name, boolean optional, Material value) {
        this(name, optional);
        this.mat = value;
    }

    @Override
    public void valueSelected(String value) {
        try {
            this.mat = Material.matchMaterial((String)value.toUpperCase());
            this.needsSave = true;
            this.setCreated(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getCurrentSelection() {
        return this.mat.name();
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + this.mat.name();
    }

    @Override
    public void reset() {
        super.reset();
        this.mat = null;
    }

    @Override
    public void addWithConfigOption(JPanel panel) {
        JPanel mainPanel = this.generateEmptyRightPanel();
        Vector<String> mats = new Vector<String>();
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material mat = materialArray[n2];
            mats.add(mat.name());
            ++n2;
        }
        Collections.sort(mats);
        JComboBox combo = new JComboBox(mats);
        combo.setAlignmentX(0.5f);
        if (this.mat != null) {
            combo.setSelectedItem(this.mat.name());
        }
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (e.getItem() == null) {
                    return;
                }
                String item = e.getItem().toString();
                Material mat = Material.valueOf((String)item);
                TraitConfigMaterialOption.this.mat = mat;
                MainFrame.treeUpdated();
            }
        });
        mainPanel.add(combo);
        panel.add((Component)mainPanel, "Center");
    }
}

