/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.standalonegui.data.option.specific;

import de.tobiyas.racesandclasses.standalonegui.data.option.AbstractTraitConfigOption;
import de.tobiyas.racesandclasses.standalonegui.data.option.OptionType;
import de.tobiyas.racesandclasses.standalonegui.gui.MainFrame;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TraitConfigIntOption
extends AbstractTraitConfigOption {
    private int intOption = 0;

    public TraitConfigIntOption(String name, boolean optional) {
        super(OptionType.Int, name, optional);
    }

    public TraitConfigIntOption(String name, boolean optional, int option) {
        this(name, optional);
        this.intOption = option;
    }

    @Override
    public boolean isAcceptable(String value) {
        if (super.isAcceptable(value)) {
            return true;
        }
        try {
            int parsed = Integer.parseInt(value);
            return parsed != Integer.MAX_VALUE;
        }
        catch (Throwable exp) {
            return false;
        }
    }

    @Override
    public void valueSelected(String value) {
        try {
            int parsed;
            this.intOption = parsed = Integer.parseInt(value);
            this.needsSave = true;
            this.setCreated(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getCurrentSelection() {
        return Integer.toString(this.intOption);
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + this.intOption;
    }

    @Override
    public void reset() {
        super.reset();
        this.intOption = 0;
    }

    @Override
    public void addWithConfigOption(JPanel panel) {
        JPanel mainPanel = this.generateEmptyRightPanel();
        final JTextField text = new JTextField(String.valueOf(this.intOption));
        text.setToolTipText("Only numbers!");
        text.setHorizontalAlignment(0);
        mainPanel.add(text);
        text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                String newValue = text.getText();
                TraitConfigIntOption.this.valueSelected(newValue);
                MainFrame.treeUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String newValue = text.getText();
                TraitConfigIntOption.this.valueSelected(newValue);
                MainFrame.treeUpdated();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                String newValue = text.getText();
                TraitConfigIntOption.this.valueSelected(newValue);
                MainFrame.treeUpdated();
            }
        });
        panel.add((Component)mainPanel, "Center");
    }
}

