/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.standalonegui.data.option.specific;

import de.tobiyas.racesandclasses.standalonegui.data.option.AbstractTraitConfigOption;
import de.tobiyas.racesandclasses.standalonegui.data.option.OptionType;
import de.tobiyas.racesandclasses.standalonegui.gui.MainFrame;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TraitConfigDoubleOption
extends AbstractTraitConfigOption {
    private double value = 0.0;

    public TraitConfigDoubleOption(String name, boolean optional) {
        super(OptionType.Double, name, optional);
    }

    public TraitConfigDoubleOption(String name, boolean optional, double value) {
        this(name, optional);
        this.value = value;
    }

    @Override
    public void valueSelected(String value) {
        try {
            this.value = Double.parseDouble(value);
            this.needsSave = true;
            this.setCreated(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getCurrentSelection() {
        return Double.toString(this.value);
    }

    @Override
    public boolean isAcceptable(String value) {
        if (super.isAcceptable(value)) {
            return true;
        }
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (Throwable exp) {
            return false;
        }
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + this.value;
    }

    @Override
    public void reset() {
        super.reset();
        this.value = 0.0;
    }

    @Override
    public void addWithConfigOption(JPanel panel) {
        JPanel mainPanel = this.generateEmptyRightPanel();
        final JTextField text = new JTextField(String.valueOf(this.value));
        text.setToolTipText("Only numbers!");
        text.setHorizontalAlignment(0);
        mainPanel.add(text);
        text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                String newValue = text.getText();
                TraitConfigDoubleOption.this.valueSelected(newValue);
                MainFrame.treeUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String newValue = text.getText();
                TraitConfigDoubleOption.this.valueSelected(newValue);
                MainFrame.treeUpdated();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                String newValue = text.getText();
                TraitConfigDoubleOption.this.valueSelected(newValue);
                MainFrame.treeUpdated();
            }
        });
        panel.add((Component)mainPanel, "Center");
    }
}

