/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.standalonegui.data.option.specific;

import de.tobiyas.racesandclasses.standalonegui.data.option.AbstractTraitConfigOption;
import de.tobiyas.racesandclasses.standalonegui.data.option.OptionType;
import de.tobiyas.racesandclasses.standalonegui.gui.MainFrame;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TraitConfigBooleanOption
extends AbstractTraitConfigOption {
    private boolean value = false;

    public TraitConfigBooleanOption(String name, boolean optional) {
        super(OptionType.Boolean, name, optional);
        this.setOptions("true", "false");
    }

    public TraitConfigBooleanOption(String name, boolean optional, boolean value) {
        this(name, optional);
        this.value = value;
    }

    @Override
    public void valueSelected(String value) {
        try {
            this.value = Boolean.parseBoolean(value);
            this.needsSave = true;
            this.setCreated(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getCurrentSelection() {
        return Boolean.toString(this.value);
    }

    @Override
    public boolean isAcceptable(String value) {
        if (super.isAcceptable(value)) {
            return true;
        }
        return value.equals("true") || value.equals("false");
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + this.value;
    }

    @Override
    public void reset() {
        super.reset();
        this.value = false;
    }

    @Override
    public void addWithConfigOption(JPanel panel) {
        JPanel mainPanel = this.generateEmptyRightPanel();
        JCheckBox check = new JCheckBox(this.name);
        check.setSelected(this.value);
        check.setHorizontalAlignment(0);
        check.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                TraitConfigBooleanOption.this.value = checkBox.isSelected();
                MainFrame.treeUpdated();
            }
        });
        mainPanel.add(check);
        panel.add((Component)mainPanel, "Center");
    }
}

