/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.standalonegui.data.option.specific;

import de.tobiyas.racesandclasses.standalonegui.data.option.AbstractTraitConfigOption;
import de.tobiyas.racesandclasses.standalonegui.data.option.OptionType;
import de.tobiyas.racesandclasses.standalonegui.gui.MainFrame;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.bukkit.block.Biome;

public class TraitConfigBiomeOption
extends AbstractTraitConfigOption {
    private Biome biome = Biome.BEACHES;

    public TraitConfigBiomeOption(String name, boolean optional) {
        super(OptionType.Biome, name, optional);
        this.options.clear();
        Biome[] biomeArray = Biome.values();
        int n = biomeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Biome biome = biomeArray[n2];
            this.options.add(biome.name());
            ++n2;
        }
    }

    public TraitConfigBiomeOption(String name, boolean optional, Biome biome) {
        this(name, optional);
        this.biome = biome;
    }

    @Override
    public void valueSelected(String value) {
        Biome[] biomeArray = Biome.values();
        int n = biomeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Biome biome = biomeArray[n2];
            if (biome.name().equalsIgnoreCase(value)) {
                this.biome = biome;
                this.needsSave = true;
                this.setCreated(true);
                break;
            }
            ++n2;
        }
    }

    @Override
    public String getCurrentSelection() {
        return this.biome.name();
    }

    @Override
    public boolean isAcceptable(String value) {
        return super.isAcceptable(value.toUpperCase());
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + this.biome.name();
    }

    @Override
    public void reset() {
        super.reset();
        this.biome = null;
    }

    @Override
    public void addWithConfigOption(JPanel panel) {
        JPanel mainPanel = this.generateEmptyRightPanel();
        Vector<String> biomes = new Vector<String>();
        Biome[] biomeArray = Biome.values();
        int n = biomeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Biome biome = biomeArray[n2];
            biomes.add(biome.name());
            ++n2;
        }
        Collections.sort(biomes);
        JComboBox combo = new JComboBox(biomes);
        if (biomes != null) {
            combo.setSelectedItem(this.biome.name());
        }
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (e.getItem() == null) {
                    return;
                }
                String item = e.getItem().toString();
                Biome biome = Biome.valueOf((String)item);
                TraitConfigBiomeOption.this.biome = biome;
                MainFrame.treeUpdated();
            }
        });
        mainPanel.add(combo);
        panel.add((Component)mainPanel, "Center");
    }
}

