/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.standalonegui.data.option;

import de.tobiyas.racesandclasses.standalonegui.data.option.OptionType;
import de.tobiyas.racesandclasses.standalonegui.data.option.TraitConfigOption;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractTraitConfigOption
implements TraitConfigOption {
    protected boolean needsSave = false;
    protected final String name;
    protected final OptionType optionType;
    protected final Set<String> options = new HashSet<String>();
    protected final boolean optional;
    protected boolean created = false;

    public AbstractTraitConfigOption(OptionType type, String name, boolean optional) {
        this.optionType = type;
        this.name = name;
        this.optional = optional;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void setCreated(boolean created) {
        this.created = created;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OptionType getOptionType() {
        return this.optionType;
    }

    @Override
    public Set<String> options() {
        return this.options;
    }

    @Override
    public TraitConfigOption setOptions(Set<String> options) {
        this.options.clear();
        this.options.addAll(options);
        return this;
    }

    @Override
    public TraitConfigOption setOptions(String ... options) {
        this.options.clear();
        this.options.addAll(Arrays.asList(options));
        return this;
    }

    @Override
    public boolean isAcceptable(String value) {
        for (String accepted : this.options) {
            if (!value.equalsIgnoreCase(accepted)) continue;
            return true;
        }
        return false;
    }

    public abstract void addWithConfigOption(JPanel var1);

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AbstractTraitConfigOption)) {
            return false;
        }
        return this.name.equals(((AbstractTraitConfigOption)other).name);
    }

    protected JPanel generateEmptyRightPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(10, 1));
        JLabel header = new JLabel("Option: " + this.name);
        header.setHorizontalAlignment(0);
        header.setFont(new Font(header.getFont().getFontName(), 1, header.getFont().getSize()));
        mainPanel.add(header);
        return mainPanel;
    }

    @Override
    public void reset() {
        this.created = false;
    }

    @Override
    public int compareTo(TraitConfigOption other) {
        return this.name.compareTo(other.getName());
    }

    @Override
    public boolean needsSave() {
        return this.needsSave;
    }

    @Override
    public void notifySaved() {
        this.needsSave = false;
    }
}

