/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.standalonegui.data;

import de.tobiyas.racesandclasses.standalonegui.data.GuiClass;
import de.tobiyas.racesandclasses.standalonegui.data.GuiRace;
import de.tobiyas.racesandclasses.standalonegui.data.NeedsSave;
import de.tobiyas.racesandclasses.standalonegui.data.option.TraitConfigOption;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.util.LinkedList;
import java.util.List;

public class GuiTrait
implements Comparable<GuiTrait>,
NeedsSave {
    private String traitType = null;
    private List<TraitConfigOption> traitConfigurationNeeded = new LinkedList<TraitConfigOption>();
    private List<TraitConfigOption> traitConfigurationOptional = new LinkedList<TraitConfigOption>();
    private GuiRace belongingRace = null;
    private GuiClass belongingClass = null;

    public GuiTrait(String traitType, List<TraitConfigOption> needed, List<TraitConfigOption> optional) {
        this.traitType = traitType;
        this.traitConfigurationNeeded.addAll(needed);
        this.traitConfigurationOptional.addAll(optional);
    }

    public GuiRace getBelongingRace() {
        return this.belongingRace;
    }

    public void setBelongingRace(GuiRace belongingRace) {
        this.belongingRace = belongingRace;
    }

    public GuiClass getBelongingClass() {
        return this.belongingClass;
    }

    public void setBelongingClass(GuiClass belongingClass) {
        this.belongingClass = belongingClass;
    }

    public String getTraitType() {
        return this.traitType;
    }

    public void setTraitType(String traitType) {
        this.traitType = traitType;
    }

    public List<TraitConfigOption> getTraitConfigurationNeeded() {
        return this.traitConfigurationNeeded;
    }

    public List<TraitConfigOption> getTraitConfigurationOptional() {
        return this.traitConfigurationOptional;
    }

    public void removeFromParent() {
        if (this.belongingClass != null) {
            this.belongingClass.removeTrait(this);
        }
        if (this.belongingRace != null) {
            this.belongingRace.removeTrait(this);
        }
    }

    @Override
    public int compareTo(GuiTrait o) {
        return this.traitType.compareTo(o.getTraitType());
    }

    @Override
    public boolean needsSave() {
        for (TraitConfigOption config : this.traitConfigurationNeeded) {
            if (!config.needsSave()) continue;
            return true;
        }
        return false;
    }

    public void saveTo(YAMLConfigExtended ymlConfig, String pre) {
        pre = String.valueOf(pre) + this.traitType;
        String addon = "";
        int i = 0;
        while (ymlConfig.contains(String.valueOf(pre) + addon)) {
            addon = "#" + ++i;
        }
        pre = String.valueOf(pre) + addon;
        ymlConfig.createSection(pre);
        pre = String.valueOf(pre) + ".";
        for (TraitConfigOption option : this.traitConfigurationNeeded) {
            ymlConfig.set(String.valueOf(pre) + option.getName(), option.getCurrentSelection());
            option.notifySaved();
        }
        for (TraitConfigOption option : this.traitConfigurationOptional) {
            if (!option.isCreated()) continue;
            ymlConfig.set(String.valueOf(pre) + option.getName(), option.getCurrentSelection());
            option.notifySaved();
        }
    }
}

