/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.standalonegui.data;

import de.tobiyas.racesandclasses.standalonegui.data.GuiTrait;
import de.tobiyas.racesandclasses.standalonegui.data.NeedsSave;
import de.tobiyas.racesandclasses.standalonegui.data.option.TraitConfigOption;
import de.tobiyas.racesandclasses.standalonegui.data.option.specific.TraitConfigStringOption;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.items.ItemUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class GuiRace
implements Comparable<GuiRace>,
NeedsSave {
    private final Set<GuiTrait> traits = new HashSet<GuiTrait>();
    private final YAMLConfigExtended ymlConfig;
    private String raceName = "NONE";
    private String raceNodeName = "NONE";
    private final Set<ItemUtils.ItemQuality> armor = new HashSet<ItemUtils.ItemQuality>();
    private final List<TraitConfigOption> config = new LinkedList<TraitConfigOption>();
    private boolean needsSave = false;

    public GuiRace(YAMLConfigExtended raceConfig, String raceName, String raceNodeName, String tag, String manaBonus, String armor, Set<GuiTrait> traits) {
        this.ymlConfig = raceConfig;
        this.traits.addAll(traits);
        this.raceNodeName = raceNodeName;
        this.raceName = raceName;
        armor = armor.toLowerCase();
        if (armor.contains("leather")) {
            this.armor.add(ItemUtils.ItemQuality.Leather);
        }
        if (armor.contains("iron")) {
            this.armor.add(ItemUtils.ItemQuality.Iron);
        }
        if (armor.contains("chain")) {
            this.armor.add(ItemUtils.ItemQuality.Chain);
        }
        if (armor.contains("gold")) {
            this.armor.add(ItemUtils.ItemQuality.Gold);
        }
        if (armor.contains("diamond")) {
            this.armor.add(ItemUtils.ItemQuality.Diamond);
        }
        if (armor.contains("all")) {
            ItemUtils.ItemQuality[] itemQualityArray = ItemUtils.ItemQuality.values();
            int n = itemQualityArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemUtils.ItemQuality i = itemQualityArray[n2];
                this.armor.add(i);
                ++n2;
            }
        }
        for (GuiTrait trait : traits) {
            trait.setBelongingRace(this);
        }
        this.config.add(new TraitConfigStringOption("name", true, raceName));
        this.config.add(new TraitConfigStringOption("manaBonus", false, manaBonus));
        this.config.add(new TraitConfigStringOption("tag", true, tag));
        Collections.sort(this.config);
    }

    public String getRaceName() {
        return this.raceName;
    }

    public String getRaceNodeName() {
        return this.raceNodeName;
    }

    public void setRaceNodeName(String raceNodeName) {
        this.raceNodeName = raceNodeName;
        this.needsSave = true;
    }

    public void setRaceName(String raceName) {
        this.raceName = raceName;
        this.needsSave = true;
    }

    public Set<ItemUtils.ItemQuality> getArmor() {
        return this.armor;
    }

    public Set<GuiTrait> getTraits() {
        return this.traits;
    }

    public void addTrait(GuiTrait trait) {
        trait.setBelongingRace(this);
        this.traits.add(trait);
        this.needsSave = true;
    }

    public void removeTrait(GuiTrait trait) {
        this.traits.remove(trait);
        this.needsSave = true;
    }

    public List<TraitConfigOption> getConfig() {
        return this.config;
    }

    public void save() {
        if (!this.needsSave()) {
            return;
        }
        this.ymlConfig.clearConfig();
        for (TraitConfigOption option : this.config) {
            this.ymlConfig.set(String.valueOf(this.raceNodeName) + ".config." + option.getName(), option.getCurrentSelection());
            option.notifySaved();
        }
        for (GuiTrait trait : this.traits) {
            trait.saveTo(this.ymlConfig, String.valueOf(this.raceNodeName) + ".traits.");
        }
        this.ymlConfig.save();
        this.needsSave = false;
    }

    @Override
    public boolean needsSave() {
        if (this.needsSave) {
            return true;
        }
        for (GuiTrait trait : this.traits) {
            if (!trait.needsSave()) continue;
            return true;
        }
        for (TraitConfigOption option : this.config) {
            if (!option.needsSave()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.raceName;
    }

    @Override
    public int compareTo(GuiRace o) {
        return this.raceName.compareTo(o.raceName);
    }
}

