/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.standalonegui.data;

import de.tobiyas.racesandclasses.standalonegui.data.GuiClass;
import de.tobiyas.racesandclasses.standalonegui.data.GuiRace;
import de.tobiyas.racesandclasses.standalonegui.data.GuiTrait;
import de.tobiyas.racesandclasses.standalonegui.data.option.TraitConfigOption;
import de.tobiyas.racesandclasses.standalonegui.data.option.TraitGuiConfigParser;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.util.RaC.collections.CaseInsenesitveMap;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.file.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.lang.annotation.AnnotationFormatError;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class GuiLoader {
    private static File baseFile;
    private static File lastSelectedBaseFile;
    private static File lastSelectedBukkitFile;
    private static ClassLoader bukkitLoader;
    private static final List<GuiClass> classes;
    private static final List<GuiRace> races;
    private static final Map<String, Class<? extends Trait>> traitMap;

    static {
        File ownMCRoot = new File("D:\\Bastelecke\\1.8.7");
        File ownBukkit = new File(ownMCRoot, "spigot.jar");
        File ownRaC = new File(new File(ownMCRoot, "plugins"), "RacesAndClasses");
        if (ownBukkit.exists()) {
            lastSelectedBukkitFile = ownBukkit;
        }
        if (ownRaC.exists()) {
            lastSelectedBaseFile = ownRaC;
        }
        classes = new LinkedList<GuiClass>();
        races = new LinkedList<GuiRace>();
        traitMap = new CaseInsenesitveMap<Class<? extends Trait>>();
    }

    public static List<GuiClass> getLoadedClasses() {
        Collections.sort(classes);
        return classes;
    }

    public static List<GuiRace> getLoadedRaces() {
        Collections.sort(races);
        return races;
    }

    public static void removeRace(GuiRace race) {
        races.remove(race);
    }

    public static void addRace(GuiRace race) {
        races.add(race);
    }

    public static void removeClass(GuiClass clazz) {
        classes.remove(clazz);
    }

    public static void addClass(GuiClass clazz) {
        classes.add(clazz);
    }

    public static void openBaseFileSelection() {
        File selected;
        int result;
        JFileChooser fileChooser;
        if (bukkitLoader == null) {
            JOptionPane.showMessageDialog(null, "Select a CraftBukkit / Spigot distribution.");
            fileChooser = new JFileChooser();
            if (lastSelectedBukkitFile != null) {
                fileChooser.setSelectedFile(lastSelectedBukkitFile);
            }
            fileChooser.setFileFilter(new javax.swing.filechooser.FileFilter(){

                @Override
                public String getDescription() {
                    return "jar";
                }

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return f.getName().endsWith(".jar");
                }
            });
            fileChooser.setFileSelectionMode(0);
            fileChooser.setDialogTitle("Select a CraftBukkit / Spigot distribution");
            result = fileChooser.showOpenDialog(null);
            if (result == 1) {
                return;
            }
            if (result == -1) {
                return;
            }
            if (result == 0) {
                lastSelectedBukkitFile = selected = fileChooser.getSelectedFile();
                if (selected == null || !selected.getName().endsWith(".jar")) {
                    JOptionPane.showMessageDialog(null, "You need to select a CraftBukkit / Spigot distribution.");
                    return;
                }
                try {
                    URLClassLoader loader = URLClassLoader.newInstance(new URL[]{selected.toURI().toURL()}, GuiLoader.class.getClassLoader());
                    Class<?> clazz = Class.forName("org.bukkit.Bukkit", true, loader);
                    if (clazz == null) {
                        JOptionPane.showMessageDialog(null, "Could not load the File you selected.");
                        return;
                    }
                    bukkitLoader = loader;
                }
                catch (Throwable exp) {
                    exp.printStackTrace();
                    JOptionPane.showMessageDialog(null, "You need to select a CraftBukkit / Spigot distribution.");
                    return;
                }
            }
        }
        JOptionPane.showMessageDialog(null, "Select your RacesAndClasses folder.");
        fileChooser = new JFileChooser();
        if (lastSelectedBaseFile != null) {
            fileChooser.setSelectedFile(lastSelectedBaseFile);
        }
        fileChooser.setDialogTitle("Select your RacesAndClasses Folder");
        fileChooser.setFileSelectionMode(1);
        result = fileChooser.showOpenDialog(null);
        if (result == 1) {
            return;
        }
        if (result == -1) {
            return;
        }
        if (result == 0) {
            lastSelectedBaseFile = selected = fileChooser.getSelectedFile();
            if (selected == null || !selected.getName().equalsIgnoreCase("RacesAndClasses")) {
                JOptionPane.showMessageDialog(null, "The folder has to be 'RacesAndClasses' base directory.");
                return;
            }
            baseFile = selected;
            GuiLoader.reloadEverything();
        }
    }

    private static void reloadEverything() {
        Set<GuiTrait> loadTraits;
        String armor;
        String tag;
        String manaBonus;
        String displayName;
        if (baseFile == null) {
            return;
        }
        GuiLoader.reloadTraits();
        File racesDir = new File(baseFile, "races");
        File classesDir = new File(baseFile, "classes");
        HashSet<YAMLConfigExtended> racesConfigs = new HashSet<YAMLConfigExtended>();
        File[] fileArray = racesDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File raceFile = fileArray[n2];
            if (raceFile.getName().endsWith(".yml")) {
                racesConfigs.add(new YAMLConfigExtended(raceFile).load());
            }
            ++n2;
        }
        HashSet<YAMLConfigExtended> classesConfigs = new HashSet<YAMLConfigExtended>();
        File[] fileArray2 = classesDir.listFiles();
        int n3 = fileArray2.length;
        n = 0;
        while (n < n3) {
            File classFile = fileArray2[n];
            if (classFile.getName().endsWith(".yml")) {
                classesConfigs.add(new YAMLConfigExtended(classFile).load());
            }
            ++n;
        }
        for (YAMLConfigExtended raceConfig : racesConfigs) {
            for (String root : raceConfig.getRootChildren()) {
                displayName = raceConfig.getString(String.valueOf(root) + ".config.name", root);
                manaBonus = raceConfig.getString(String.valueOf(root) + ".config.manabonus", "+0");
                tag = raceConfig.getString(String.valueOf(root) + ".config.tag", "");
                armor = raceConfig.getString(String.valueOf(root) + ".config.armor", "");
                loadTraits = GuiLoader.loadTraits(raceConfig, root);
                GuiRace race = new GuiRace(raceConfig, displayName, root, tag, manaBonus, armor, loadTraits);
                races.add(race);
            }
        }
        for (YAMLConfigExtended classConfig : classesConfigs) {
            for (String root : classConfig.getRootChildren()) {
                displayName = classConfig.getString(String.valueOf(root) + ".config.name", root);
                manaBonus = classConfig.getString(String.valueOf(root) + ".config.manabonus", "+0");
                tag = classConfig.getString(String.valueOf(root) + ".config.tag", "");
                armor = classConfig.getString(String.valueOf(root) + ".config.armor", "");
                loadTraits = GuiLoader.loadTraits(classConfig, root);
                GuiClass clazz = new GuiClass(classConfig, displayName, root, tag, manaBonus, armor, loadTraits);
                classes.add(clazz);
            }
        }
    }

    private static Set<GuiTrait> loadTraits(YAMLConfigExtended config, String name) {
        Set<String> names = config.getChildren(String.valueOf(name) + ".traits");
        HashSet<GuiTrait> traits = new HashSet<GuiTrait>();
        for (String traitName : names) {
            GuiTrait trait = GuiLoader.loadTrait(config, String.valueOf(name) + ".traits", traitName);
            if (trait == null) continue;
            traits.add(trait);
        }
        return traits;
    }

    private static GuiTrait loadTrait(YAMLConfigExtended config, String path, String traitPath) {
        Class<? extends Trait> traitClass;
        if (config == null || path == null || path.isEmpty()) {
            return null;
        }
        if (!config.contains(path)) {
            return null;
        }
        String traitName = traitPath;
        if (traitPath.contains("#")) {
            traitName = traitName.split(Pattern.quote("#"))[0];
        }
        if ((traitClass = traitMap.get(traitName = config.getString(String.valueOf(path) + "." + traitPath + ".trait", traitName))) == null) {
            return null;
        }
        GuiTrait trait = TraitGuiConfigParser.generateEmptyConfig(traitClass);
        for (TraitConfigOption option : trait.getTraitConfigurationNeeded()) {
            if (!config.contains(String.valueOf(path) + "." + traitPath + "." + option.getName())) continue;
            String value = config.get(String.valueOf(path) + "." + traitPath + "." + option.getName()).toString();
            option.setCreated(true);
            option.valueSelected(value);
        }
        return trait;
    }

    private static void reloadTraits() {
        traitMap.clear();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        };
        Set<File> files = FileUtils.getAllFiles(new File(baseFile, "traits"), filter);
        for (File file : files) {
            GuiLoader.loadExternalTrait(file);
        }
    }

    private static void loadExternalTrait(File file) {
        try {
            URLClassLoader clazzLoader = URLClassLoader.newInstance(new URL[]{file.toURI().toURL()}, bukkitLoader);
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            HashSet clazzArray = new HashSet();
            while (entries.hasMoreElements()) {
                JarEntry element = entries.nextElement();
                if (!element.getName().endsWith(".class")) continue;
                try {
                    Class<?> clazz = clazzLoader.loadClass(element.getName().replaceAll(".class", "").replaceAll("/", "."));
                    if (clazz == null || !Trait.class.isAssignableFrom(clazz)) continue;
                    clazzArray.add(clazz);
                }
                catch (Throwable e) {
                    System.out.println("Could not load Java Class: " + element.getName() + ". In: " + jarFile.getName());
                }
            }
            boolean hasClass = false;
            for (Class<?> clazz : clazzArray) {
                try {
                    if (clazz == null) continue;
                    boolean isPresent = clazz.getMethod("importTrait", new Class[0]).isAnnotationPresent(TraitInfos.class);
                    if (isPresent) {
                        TraitInfos annotation = clazz.getMethod("importTrait", new Class[0]).getAnnotation(TraitInfos.class);
                        hasClass = true;
                        String name = annotation.traitName();
                        traitMap.put(name, clazz);
                        continue;
                    }
                    throw new AnnotationFormatError("Annotation: Import could not be found for class: " + clazz);
                }
                catch (AnnotationFormatError e) {
                    System.out.println(e.getLocalizedMessage());
                }
            }
            jarFile.close();
            if (!hasClass) {
                throw new AnnotationFormatError("Annotation: Import could not be found for file: " + file.getName());
            }
        }
        catch (NoClassDefFoundError e) {
            String message = "Unable to load " + file.getName() + ". Probably it was written for a previous Races version!";
            System.out.println(message);
            return;
        }
        catch (AnnotationFormatError e) {
            System.out.println(e.getLocalizedMessage());
        }
        catch (Throwable e) {
            String message = "The trait " + file.getName() + " failed to load for an unknown reason.";
            System.out.println(message);
            e.printStackTrace();
        }
    }

    public static void save() {
        for (GuiRace race : races) {
            race.save();
        }
        for (GuiClass clazz : classes) {
            clazz.save();
        }
    }
}

