/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.standalonegui.data;

import de.tobiyas.racesandclasses.standalonegui.data.GuiTrait;
import de.tobiyas.racesandclasses.standalonegui.data.NeedsSave;
import de.tobiyas.racesandclasses.standalonegui.data.option.TraitConfigOption;
import de.tobiyas.racesandclasses.standalonegui.data.option.specific.TraitConfigStringOption;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class GuiClass
implements Comparable<GuiClass>,
NeedsSave {
    private final Set<GuiTrait> traits = new HashSet<GuiTrait>();
    private String className = "NONE";
    private String classNodeName = "NONE";
    private final List<TraitConfigOption> config = new LinkedList<TraitConfigOption>();
    private final YAMLConfigExtended ymlConfig;
    private boolean needsSave = false;

    public GuiClass(YAMLConfigExtended ymlConfig, String name, String nodeName, String tag, String manaBonus, String armor, Set<GuiTrait> traits) {
        this.ymlConfig = ymlConfig;
        this.traits.addAll(traits);
        this.classNodeName = nodeName;
        this.className = name;
        for (GuiTrait trait : traits) {
            trait.setBelongingClass(this);
        }
        this.config.add(new TraitConfigStringOption("name", true, this.className));
        this.config.add(new TraitConfigStringOption("manaBonus", false, manaBonus));
        this.config.add(new TraitConfigStringOption("tag", true, tag));
        Collections.sort(this.config);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
        this.needsSave = true;
    }

    public String getClassNodeName() {
        return this.classNodeName;
    }

    public void setClassNodeName(String classNodeName) {
        this.classNodeName = classNodeName;
        this.needsSave = true;
    }

    public void save() {
        if (!this.needsSave()) {
            return;
        }
        this.ymlConfig.clearConfig();
        for (TraitConfigOption option : this.config) {
            this.ymlConfig.set(String.valueOf(this.classNodeName) + ".config." + option.getName(), option.getCurrentSelection());
        }
        for (GuiTrait trait : this.traits) {
            trait.saveTo(this.ymlConfig, String.valueOf(this.classNodeName) + ".traits.");
        }
        this.ymlConfig.save();
        this.needsSave = false;
    }

    @Override
    public boolean needsSave() {
        if (this.needsSave) {
            return true;
        }
        for (GuiTrait trait : this.traits) {
            if (!trait.needsSave()) continue;
            return true;
        }
        for (TraitConfigOption option : this.config) {
            if (!option.needsSave()) continue;
            return true;
        }
        return false;
    }

    public Set<GuiTrait> getTraits() {
        return this.traits;
    }

    public void addTrait(GuiTrait trait) {
        trait.setBelongingClass(this);
        this.traits.add(trait);
        this.needsSave = true;
    }

    public void removeTrait(GuiTrait trait) {
        this.traits.remove(trait);
        this.needsSave = true;
    }

    public String toString() {
        return this.className;
    }

    @Override
    public int compareTo(GuiClass o) {
        return this.className.compareTo(o.className);
    }

    public List<TraitConfigOption> getConfig() {
        return this.config;
    }
}

