/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.saving.serializer;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.racesandclasses.saving.serializer.PlayerDataSerializer;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.plugin.Plugin;

public class YAMLPlayerDataSerializer
implements PlayerDataSerializer {
    private final RacesAndClasses plugin;
    private final File saveDir;

    public YAMLPlayerDataSerializer(RacesAndClasses plugin) {
        this.plugin = plugin;
        this.saveDir = new File(plugin.getDataFolder(), "PlayerDataYML");
        if (!this.saveDir.exists()) {
            this.saveDir.mkdirs();
        }
    }

    @Override
    public void saveData(PlayerSavingData data) {
        boolean sync = RacesAndClasses.isBukkitInShutdownMode();
        this.saveData(data, sync);
    }

    private void saveData(PlayerSavingData data, boolean sync) {
        UUID playerID = data.getPlayerId();
        File playerFile = new File(this.saveDir, String.valueOf(playerID.toString()) + ".yml");
        YAMLConfigExtended config = new YAMLConfigExtended(playerFile);
        config.set("id", playerID.toString());
        config.set("lastname", data.getLastName());
        config.set("race", data.getRaceName());
        config.set("class", data.getClassName());
        config.set("level", data.getLevel());
        config.set("exp", data.getLevelExp());
        config.set("lastplayed", data.getLastLogin());
        config.set("god", data.isGodModeEnabled());
        for (Map.Entry<Integer, String> entry : data.getHotKeys().entrySet()) {
            config.set("hotkeys." + entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : data.getSkillTree().entrySet()) {
            config.set("skilltree." + (String)entry.getKey(), entry.getValue());
        }
        if (sync) {
            config.save();
        } else {
            config.saveAsync();
        }
    }

    @Override
    public void loadData(final UUID id, final PlayerDataSerializer.PlayerDataLoadedCallback callback) {
        new DebugBukkitRunnable("RaCSingleLoader"){

            @Override
            protected void runIntern() {
                PlayerSavingData data = YAMLPlayerDataSerializer.this.loadDataNow(id);
                callback.playerDataLoaded(data);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    @Override
    public void bulkLoadData(final Set<UUID> ids, final PlayerDataSerializer.PlayerDataLoadedCallback callback) {
        new DebugBukkitRunnable("RaCBulkLoader"){

            @Override
            protected void runIntern() {
                for (UUID id : ids) {
                    PlayerSavingData data = YAMLPlayerDataSerializer.this.loadDataNow(id);
                    callback.playerDataLoaded(data);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public Set<PlayerSavingData> bulkLoadDataNow(Set<UUID> ids) {
        HashSet<PlayerSavingData> datas = new HashSet<PlayerSavingData>();
        for (UUID id : ids) {
            PlayerSavingData data = this.loadDataNow(id);
            if (data == null) continue;
            datas.add(data);
        }
        return datas;
    }

    @Override
    public PlayerSavingData loadDataNow(UUID id) {
        File playerFile = new File(this.saveDir, String.valueOf(id.toString()) + ".yml");
        if (!playerFile.exists()) {
            return new PlayerSavingData(id);
        }
        YAMLConfigExtended config = new YAMLConfigExtended(playerFile).load();
        if (!config.getValidLoad()) {
            this.plugin.logDebug("Could not load PlayerData: " + id.toString());
            return new PlayerSavingData(id);
        }
        String raceName = config.getString("race", "");
        String className = config.getString("class", "");
        String lastName = config.getString("lastname", "");
        boolean godMode = config.getBoolean("god", false);
        int level = config.getInt("level", 1);
        int exp = config.getInt("exp", 0);
        long lastPlayed = config.getLong("lastplayed", 0L);
        HashMap<Integer, String> hotkeys = new HashMap<Integer, String>();
        for (String keyName : config.getChildren("hotkeys")) {
            try {
                int key = Integer.parseInt(keyName);
                String trait = config.getString("hotkeys." + key, "");
                if (trait.isEmpty()) continue;
                hotkeys.put(key, trait);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        HashMap<String, Integer> skillTree = new HashMap<String, Integer>();
        for (String trait : config.getChildren("skilltree")) {
            try {
                int traitLevel = config.getInt("skilltree." + trait, 0);
                if (traitLevel <= 0) continue;
                skillTree.put(trait, traitLevel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new PlayerSavingData(id, lastPlayed, lastName, raceName, className, level, exp, godMode, hotkeys, skillTree);
    }

    @Override
    public Set<UUID> getAllIDsPresent() {
        File[] files = this.saveDir.listFiles();
        HashSet<UUID> ids = new HashSet<UUID>();
        if (files == null || files.length == 0) {
            return ids;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                String name = file.getName().replace(".yml", "");
                UUID id = UUID.fromString(name);
                if (id != null) {
                    ids.add(id);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        return ids;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isFunctional() {
        return true;
    }
}

