/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.saving.serializer;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.racesandclasses.saving.serializer.PlayerDataSerializer;
import de.tobiyas.util.RaC.file.IOUtils;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import de.tobiyas.util.RaC.sql.SQL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.plugin.Plugin;

public class DatabasePlayerDataSerializer
implements PlayerDataSerializer {
    private static final String TABLE_NAME = "RacesAndClasses";
    private final RacesAndClasses plugin;
    private Connection connection;

    public DatabasePlayerDataSerializer(RacesAndClasses plugin) {
        this.plugin = plugin;
    }

    @Override
    public void saveData(PlayerSavingData data) {
        boolean sync = RacesAndClasses.isBukkitInShutdownMode();
        this.saveData(data, sync);
    }

    public void saveData(final PlayerSavingData data, boolean sync) {
        DebugBukkitRunnable runnable = new DebugBukkitRunnable("LoadRaCData"){

            @Override
            protected void runIntern() {
                Statement statement = null;
                try {
                    DatabasePlayerDataSerializer.this.checkConnection();
                    if (DatabasePlayerDataSerializer.this.connection == null) {
                        RacesAndClasses.getPlugin().logWarning("Could not open DB connection! Please change to YML stuff!");
                        return;
                    }
                    try {
                        statement = DatabasePlayerDataSerializer.this.connection.createStatement();
                        String sqlUpdateStatement = "REPLACE INTO `RacesAndClasses` (id,lastLogin,lastName,race,class,level,exp,godMode,additionalData)  VALUES ('" + data.getPlayerId().toString() + "'," + data.getLastLogin() + "," + "'" + data.getLastName() + "'," + "'" + data.getRaceName() + "'," + "'" + data.getClassName() + "'," + data.getLevel() + "," + data.getLevelExp() + "," + (data.isGodMode() ? 1 : 0) + "," + "'" + data.getAdditionalJsonData().replace("'", "\\'") + "'" + ")";
                        statement.execute(sqlUpdateStatement);
                    }
                    catch (Throwable exp) {
                        exp.printStackTrace();
                    }
                }
                finally {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        };
        if (sync) {
            runnable.run();
        } else {
            runnable.runTaskAsynchronously((Plugin)this.plugin);
        }
    }

    @Override
    public void loadData(final UUID id, final PlayerDataSerializer.PlayerDataLoadedCallback callback) {
        new DebugBukkitRunnable("LoadRaCData"){

            @Override
            protected void runIntern() {
                PlayerSavingData data = DatabasePlayerDataSerializer.this.loadDataNow(id);
                callback.playerDataLoaded(data);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    @Override
    public Collection<PlayerSavingData> bulkLoadDataNow(Set<UUID> ids) {
        HashSet<PlayerSavingData> datas;
        block8: {
            datas = new HashSet<PlayerSavingData>();
            StringBuilder selectQueryBuilder = new StringBuilder();
            selectQueryBuilder.append("SELECT * FROM `").append(TABLE_NAME).append("` WHERE id IN (");
            boolean first = true;
            for (UUID id : ids) {
                if (!first) {
                    selectQueryBuilder.append(",");
                }
                first = false;
                selectQueryBuilder.append("'").append(id).append("'");
            }
            selectQueryBuilder.append(")");
            Connection connection = null;
            Statement statement = null;
            ResultSet result = null;
            try {
                try {
                    connection = SQL.getSQLConnection(this.getProperties());
                    String query = selectQueryBuilder.toString();
                    this.checkConnection();
                    statement = connection.createStatement();
                    result = statement.executeQuery(query);
                    while (result.next()) {
                        PlayerSavingData data = this.analyseCurrentResultLine(result);
                        if (data == null) continue;
                        datas.add(data);
                    }
                }
                catch (Throwable exp) {
                    exp.printStackTrace();
                    IOUtils.closeQuietly(statement);
                    IOUtils.closeQuietly(result);
                    IOUtils.closeQuietly(connection);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(statement);
                IOUtils.closeQuietly(result);
                IOUtils.closeQuietly(connection);
                throw throwable;
            }
            IOUtils.closeQuietly(statement);
            IOUtils.closeQuietly(result);
            IOUtils.closeQuietly(connection);
        }
        return datas;
    }

    @Override
    public void bulkLoadData(final Set<UUID> ids, final PlayerDataSerializer.PlayerDataLoadedCallback callback) {
        new DebugBukkitRunnable("LoadRaCData"){

            @Override
            protected void runIntern() {
                for (PlayerSavingData data : DatabasePlayerDataSerializer.this.bulkLoadDataNow(ids)) {
                    callback.playerDataLoaded(data);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private PlayerSavingData analyseCurrentResultLine(ResultSet resultSet) {
        try {
            int columns = resultSet.getMetaData().getColumnCount();
            if (columns < 9) {
                RacesAndClasses.getPlugin().logError("Something on the DB is broken!");
            }
            UUID id = UUID.fromString(resultSet.getString(1));
            long lastLogin = resultSet.getLong(2);
            String lastName = resultSet.getString(3);
            String raceName = resultSet.getString(4);
            String className = resultSet.getString(5);
            int level = resultSet.getInt(6);
            int exp = resultSet.getInt(7);
            boolean god = resultSet.getInt(8) == 1;
            String additionalData = resultSet.getString(9);
            PlayerSavingData data = new PlayerSavingData(id, lastLogin, lastName, raceName, className, level, exp, god, null, null);
            data.setAdditionalJsonData(additionalData);
            data.unserializeJsonData();
            return data;
        }
        finally {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlayerSavingData loadDataNow(UUID id) {
        PlayerSavingData data = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String sqlSelectStatement;
            this.checkConnection();
            if (this.connection == null) {
                RacesAndClasses.getPlugin().logWarning("Could not open DB connection! Please change to YML stuff!");
                return null;
            }
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(sqlSelectStatement = "SELECT * FROM `RacesAndClasses` WHERE  id='" + id.toString() + "'");
            if (!resultSet.next()) {
                return null;
            }
            data = this.analyseCurrentResultLine(resultSet);
            return data;
        }
        catch (Throwable exp) {
            exp.printStackTrace();
            return data;
        }
        finally {
            try {
                statement.close();
            }
            catch (Throwable throwable) {}
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public Set<UUID> getAllIDsPresent() {
        HashSet<UUID> ids = new HashSet<UUID>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            this.checkConnection();
            if (this.connection == null) {
                RacesAndClasses.getPlugin().logWarning("Could not open DB connection! Please change to YML stuff!");
                return null;
            }
            try {
                statement = this.connection.createStatement();
                String sqlSelectStatement = "SELECT id FROM `RacesAndClasses`";
                resultSet = statement.executeQuery(sqlSelectStatement);
                while (resultSet.next()) {
                    try {
                        String id = resultSet.getString(1);
                        UUID uID = UUID.fromString(id);
                        if (id == null) continue;
                        ids.add(uID);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable exp) {
                exp.printStackTrace();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Throwable throwable) {}
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        return ids;
    }

    @Override
    public void shutdown() {
    }

    private SQL.SQLProperties getProperties() {
        return RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_databaseData();
    }

    @Override
    public boolean isFunctional() {
        boolean reachable;
        SQL.SQLProperties props;
        block5: {
            block4: {
                props = this.getProperties();
                try {
                    SQL.init(this.plugin);
                    Connection connection = SQL.getSQLConnection(props);
                    if (connection != null) break block4;
                    return false;
                }
                catch (Throwable exp) {
                    exp.printStackTrace();
                    return false;
                }
            }
            reachable = SQL.checkDBIsReachable(props);
            if (reachable) break block5;
            return false;
        }
        String sqlCommand = "CREATE TABLE IF NOT EXISTS `RacesAndClasses`(`id` VARCHAR(64) NOT NULL,`lastLogin` BIGINT NOT NULL DEFAULT '0',`lastName` VARCHAR(32) NOT NULL DEFAULT '',`race` VARCHAR(32) NOT NULL DEFAULT '',`class` VARCHAR(32) NOT NULL DEFAULT '',`level` INT NOT NULL DEFAULT '0',`exp` INT NOT NULL DEFAULT '0',`godMode` TINYINT NOT NULL DEFAULT '0',`additionalData` MEDIUMTEXT NOT NULL,PRIMARY KEY (`id`))";
        SQL.tryCreateDBIfNotExist(props, "", sqlCommand);
        return reachable;
    }

    private void checkConnection() {
        if (this.connection == null) {
            try {
                this.connection = SQL.getSQLConnection(this.getProperties());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void GENERATE_AND_UPLOAD_DATA() {
        int i = 0;
        while (i <= 10) {
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("INSERT INTO `").append(TABLE_NAME).append("` (id,additionalData) VALUES ");
            int j = 0;
            while (j <= 10000) {
                queryBuilder.append("('").append(UUID.randomUUID()).append("','").append("{text=\"" + this.generateRandomString(200) + "\"}").append("')");
                if (j != 10000) {
                    queryBuilder.append(",");
                }
                ++j;
            }
            this.checkConnection();
            try {
                Statement st = this.connection.createStatement();
                st.execute(queryBuilder.toString());
                st.close();
            }
            catch (Throwable exp) {
                exp.printStackTrace();
            }
            ++i;
        }
    }

    protected String generateRandomString(int length) {
        Random rand = new Random();
        String set = "";
        int i = 0;
        while (i < length) {
            char cha = (char)(97 + rand.nextInt(20));
            set = String.valueOf(set) + cha;
            ++i;
        }
        return set;
    }
}

