/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.saving.dataconverter.v1_1_11;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.saving.dataconverter.Converter;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.file.FileUtils;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class V1_1_10ToV1_1_11Converter
implements Converter {
    private static final String OLD_NAME = "PlayerData";
    private static final String NEW_NAME = "PlayerDataYML";
    private static final long NOTIFY_TIME = 5000L;

    @Override
    public void convert() {
        File toConvert = new File(RacesAndClasses.getPlugin().getDataFolder(), OLD_NAME);
        File newDir = new File(RacesAndClasses.getPlugin().getDataFolder(), NEW_NAME);
        Set<File> oldFiles = FileUtils.getAllFiles(toConvert);
        int size = oldFiles.size();
        if (size <= 0) {
            return;
        }
        int index = 0;
        long lastNotify = System.currentTimeMillis();
        System.out.println("Convertig Player-Data to V1_1_11: " + size + " Entries");
        for (File file : oldFiles) {
            ++index;
            if (!file.getName().endsWith(".yml")) {
                file.delete();
                continue;
            }
            YAMLConfigExtended oldConfig = new YAMLConfigExtended(file).load();
            if (!oldConfig.getValidLoad()) continue;
            YAMLConfigExtended newConfig = new YAMLConfigExtended(new File(newDir, file.getName()));
            newConfig.set("id", oldConfig.getString("uuid", ""));
            newConfig.set("lastplayed", oldConfig.getLong("lastOnline", 0L));
            newConfig.set("lastname", oldConfig.getString("lastKnownName", ""));
            newConfig.set("race", oldConfig.get("race", ""));
            newConfig.set("class", oldConfig.get("class", ""));
            newConfig.set("level", oldConfig.getInt("level.currentLevel", 1));
            newConfig.set("exp", oldConfig.getInt("level.currentLevelEXP", 0));
            List<String> oldBindings = oldConfig.getStringList("bindings");
            for (String line : oldBindings) {
                String[] lineSplit = line.split(Pattern.quote("|"));
                if (lineSplit.length != 2) continue;
                newConfig.set("hotkeys." + lineSplit[0], lineSplit[1]);
            }
            List<String> skillTree = oldConfig.getStringList("learnedTraits");
            for (String line : skillTree) {
                String[] lineSplit = line.split(Pattern.quote("@"));
                if (lineSplit.length != 2) continue;
                newConfig.set("skilltree." + lineSplit[0], lineSplit[1]);
            }
            newConfig.save();
            file.delete();
            if (lastNotify + 5000L >= System.currentTimeMillis()) continue;
            double percent = (double)index / (double)size * 100.0;
            System.out.println("Converted " + (int)percent + " for V1_1_11 data. " + index + "/" + size);
            lastNotify = System.currentTimeMillis();
        }
        toConvert.delete();
    }

    @Override
    public boolean isApplyable() {
        RacesAndClasses plugin = RacesAndClasses.getPlugin();
        File folder = new File(plugin.getDataFolder(), OLD_NAME);
        if (!folder.exists()) {
            return false;
        }
        File[] files = folder.listFiles();
        return files != null && files.length != 0;
    }

    @Override
    public int getVersion() {
        return 65802;
    }
}

