/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.saving;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.racesandclasses.saving.serializer.DatabasePlayerDataSerializer;
import de.tobiyas.racesandclasses.saving.serializer.DisabledDataSerializer;
import de.tobiyas.racesandclasses.saving.serializer.PlayerDataSerializer;
import de.tobiyas.racesandclasses.saving.serializer.YAMLPlayerDataSerializer;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.plugin.Plugin;

public class PlayerSavingManager
implements PlayerDataSerializer.PlayerDataLoadedCallback {
    private static PlayerSavingManager instance;
    private final PlayerDataSerializer serializer;
    private final RacesAndClasses plugin;
    private final Map<UUID, PlayerSavingData> playerSaveMap = new HashMap<UUID, PlayerSavingData>();

    private PlayerSavingManager() {
        this.plugin = RacesAndClasses.getPlugin();
        String serializerName = this.plugin.getConfigManager().getGeneralConfig().getConfig_serializer();
        PlayerDataSerializer.DataSerializerType type = this.fromString(serializerName);
        this.serializer = this.generateSerializer(type);
        boolean asyncLoadAll = this.plugin.getConfigManager().getGeneralConfig().isConfig_preload_data_async();
        if (asyncLoadAll) {
            this.startAsyncLoading();
        }
    }

    protected void startAsyncLoading() {
        new DebugBukkitRunnable("BulkID-Loader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runIntern() {
                Set<UUID> toLoad = PlayerSavingManager.this.serializer.getAllIDsPresent();
                if (toLoad.isEmpty()) {
                    return;
                }
                int i = 0;
                int MAX_TO_LOAD_PER_BULK = PlayerSavingManager.this.plugin.getConfigManager().getGeneralConfig().getConfig_preload_bulk_amount();
                HashSet<UUID> toLoadCopied = new HashSet<UUID>();
                for (UUID id : toLoad) {
                    toLoadCopied.add(id);
                    if (i % MAX_TO_LOAD_PER_BULK == 0 && i > 0) {
                        Collection<PlayerSavingData> datas = PlayerSavingManager.this.serializer.bulkLoadDataNow(toLoadCopied);
                        Map map = PlayerSavingManager.this.playerSaveMap;
                        synchronized (map) {
                            for (PlayerSavingData data : datas) {
                                if (data == null || PlayerSavingManager.this.playerSaveMap.containsKey(data.getPlayerId())) continue;
                                PlayerSavingManager.this.playerSaveMap.put(data.getPlayerId(), data);
                            }
                        }
                        toLoadCopied.clear();
                    }
                    ++i;
                }
                RacesAndClasses.getPlugin().log("Pre-Loaded " + i + " Player-Data. Done.");
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private PlayerDataSerializer.DataSerializerType fromString(String name) {
        if (name == null) {
            return PlayerDataSerializer.DataSerializerType.YAML;
        }
        if ((name = name.toLowerCase()).startsWith("y") || name.startsWith("f")) {
            return PlayerDataSerializer.DataSerializerType.YAML;
        }
        if (name.startsWith("o") || name.startsWith("di")) {
            return PlayerDataSerializer.DataSerializerType.DISABLED;
        }
        if (name.startsWith("da") || name.startsWith("my") || name.startsWith("sql")) {
            return PlayerDataSerializer.DataSerializerType.DATABASE;
        }
        return PlayerDataSerializer.DataSerializerType.YAML;
    }

    private PlayerDataSerializer generateSerializer(PlayerDataSerializer.DataSerializerType type) {
        PlayerDataSerializer serializer = null;
        switch (type) {
            case DATABASE: {
                serializer = new DatabasePlayerDataSerializer(this.plugin);
                break;
            }
            case DISABLED: {
                serializer = new DisabledDataSerializer();
                break;
            }
            default: {
                serializer = new YAMLPlayerDataSerializer(this.plugin);
            }
        }
        if (serializer == null || !serializer.isFunctional()) {
            if (type == PlayerDataSerializer.DataSerializerType.DATABASE) {
                RacesAndClasses.getPlugin().logWarning("Could not establish DB-Connection! Switching to YML files!");
            }
            serializer = new YAMLPlayerDataSerializer(this.plugin);
        }
        return serializer;
    }

    protected PlayerDataSerializer getSerializer() {
        return this.serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerSavingData getPlayerData(UUID id) {
        PlayerSavingData data = null;
        Map<UUID, PlayerSavingData> map = this.playerSaveMap;
        synchronized (map) {
            data = this.playerSaveMap.get(id);
        }
        if (data != null) {
            return data;
        }
        data = this.serializer.loadDataNow(id);
        if (data == null) {
            data = new PlayerSavingData(id);
        }
        map = this.playerSaveMap;
        synchronized (map) {
            this.playerSaveMap.put(id, data);
        }
        return data;
    }

    private void shutdownInstance() {
        this.serializer.shutdown();
    }

    public static PlayerSavingManager get() {
        if (instance == null) {
            instance = new PlayerSavingManager();
        }
        return instance;
    }

    public static void reload() {
        PlayerSavingManager.shutdown();
        instance = new PlayerSavingManager();
    }

    public static void shutdown() {
        if (instance != null) {
            instance.shutdownInstance();
        }
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playerDataLoaded(PlayerSavingData data) {
        if (data == null) {
            return;
        }
        Map<UUID, PlayerSavingData> map = this.playerSaveMap;
        synchronized (map) {
            if (!this.playerSaveMap.containsKey(data.getPlayerId())) {
                this.playerSaveMap.put(data.getPlayerId(), data);
            }
        }
    }
}

