/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.saving;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.tobiyas.racesandclasses.saving.PlayerSavingManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PlayerSavingData {
    private UUID playerId;
    private long lastLogin = 0L;
    private String lastName = "";
    private String raceName = "";
    private String className = "";
    private int level = 1;
    private int levelExp = 0;
    private boolean godMode = false;
    private final Map<Integer, String> hotKeys = new HashMap<Integer, String>();
    private final Map<String, Integer> skillTree = new HashMap<String, Integer>();
    private String additionalJsonData = "";

    public PlayerSavingData(UUID playerId) {
        this.playerId = playerId;
    }

    public PlayerSavingData(UUID playerId, long lastLogin, String lastName, String raceName, String className, int level, int levelExp, boolean godMode, Map<Integer, String> hotKeys, Map<String, Integer> skillTree) {
        this.playerId = playerId;
        this.lastName = lastName;
        this.lastLogin = lastLogin;
        this.raceName = raceName;
        this.className = className;
        this.level = level;
        this.levelExp = levelExp;
        this.godMode = godMode;
        if (hotKeys != null) {
            this.hotKeys.putAll(hotKeys);
        }
        if (skillTree != null) {
            this.skillTree.putAll(skillTree);
        }
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(long lastLogin) {
        if (lastLogin != this.lastLogin) {
            return;
        }
        this.lastLogin = lastLogin;
        this.save();
    }

    public String getRaceName() {
        return this.raceName;
    }

    public void setRaceName(String raceName) {
        if (raceName.equals(this.raceName)) {
            return;
        }
        this.raceName = raceName;
        this.save();
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        if (this.lastName.equals(lastName)) {
            return;
        }
        this.lastName = lastName;
        this.save();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        if (className.equals(this.className)) {
            return;
        }
        this.className = className;
        this.save();
    }

    public void setGodMode(boolean godMode) {
        this.godMode = godMode;
        this.save();
    }

    public boolean isGodModeEnabled() {
        return this.godMode;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (this.level == level) {
            return;
        }
        this.level = level;
        this.save();
    }

    public void setLevelExp(int levelExp) {
        if (this.levelExp == levelExp) {
            return;
        }
        this.levelExp = levelExp;
        this.save();
    }

    public void setLevelAndExp(int level, int levelExp) {
        if (this.level == level && this.levelExp == levelExp) {
            return;
        }
        this.level = level;
        this.levelExp = levelExp;
        this.save();
    }

    public int getLevelExp() {
        return this.levelExp;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(UUID playerId) {
        this.playerId = playerId;
    }

    public void setHotKey(Integer slot, String trait) {
        this.hotKeys.put(slot, trait);
        this.save();
    }

    public void setHotKeys(Map<Integer, String> hotKeys) {
        this.hotKeys.clear();
        this.hotKeys.putAll(hotKeys);
        this.save();
    }

    public void clearHotKeys() {
        this.hotKeys.clear();
        this.save();
    }

    public void clearHotKey(int slot) {
        this.hotKeys.remove(slot);
        this.save();
    }

    public Map<Integer, String> getHotKeys() {
        return new HashMap<Integer, String>(this.hotKeys);
    }

    public void overrideSkilltree(Map<String, Integer> map) {
        this.skillTree.clear();
        this.skillTree.putAll(map);
        this.save();
    }

    public Map<String, Integer> getSkillTree() {
        return new HashMap<String, Integer>(this.skillTree);
    }

    public void clearSkilltree() {
        this.skillTree.clear();
        this.save();
    }

    private void save() {
        if (this.raceName.isEmpty() && this.className.isEmpty() && this.hotKeys.isEmpty() && this.skillTree.isEmpty()) {
            return;
        }
        this.updateSerializedJsonData();
        PlayerSavingManager.get().getSerializer().saveData(this);
    }

    private void updateSerializedJsonData() {
        JsonObject root = new JsonObject();
        JsonObject rootNode = new JsonObject();
        root.add("hotkey", rootNode);
        for (Map.Entry<Integer, String> entry : this.hotKeys.entrySet()) {
            rootNode.addProperty(String.valueOf(entry.getKey()), entry.getValue());
        }
        rootNode = new JsonObject();
        root.add("skilltree", rootNode);
        for (Map.Entry<Object, Object> entry : this.skillTree.entrySet()) {
            rootNode.addProperty((String)entry.getKey(), (Number)entry.getValue());
        }
        this.additionalJsonData = root.toString();
    }

    public void unserializeJsonData() {
        JsonParser parser = new JsonParser();
        try {
            JsonObject obj = (JsonObject)parser.parse(this.additionalJsonData);
            if (obj.has("hotkey")) {
                this.hotKeys.clear();
                JsonElement hotKeyRoot = obj.get("hotkey");
                if (hotKeyRoot.isJsonObject()) {
                    JsonObject hkObj = hotKeyRoot.getAsJsonObject();
                    for (Map.Entry<String, JsonElement> entry : hkObj.entrySet()) {
                        int key = Integer.getInteger(entry.getKey());
                        String trait = entry.getValue().getAsString();
                        this.hotKeys.put(key, trait);
                    }
                }
            }
            if (obj.has("skilltree")) {
                this.skillTree.clear();
                JsonElement stRoot = obj.get("skilltree");
                if (stRoot.isJsonObject()) {
                    JsonObject stObj = stRoot.getAsJsonObject();
                    for (Map.Entry<String, JsonElement> entry : stObj.entrySet()) {
                        String trait = entry.getKey();
                        int level = entry.getValue().getAsInt();
                        this.skillTree.put(trait, level);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getAdditionalJsonData() {
        return this.additionalJsonData;
    }

    public void setAdditionalJsonData(String additionalJsonData) {
        this.additionalJsonData = additionalJsonData;
    }

    public boolean isGodMode() {
        return this.godMode;
    }
}

