/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.racbuilder.gui.trait;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.racbuilder.gui.trait.TraitConfigOptionContainer;
import de.tobiyas.racesandclasses.traitcontainer.container.TraitsList;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.items.ItemMetaUtils;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigParser;
import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.StatType;
import de.tobiyas.util.RaC.inventorymenu.stats.StatsSelectionInterfaceFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class TraitBuilderInterface
extends BasicSelectionInterface {
    private final List<TraitConfigOptionContainer> configList;
    private final Map<String, Object> tempConfigList = new HashMap<String, Object>();
    private TraitConfigOptionContainer optionToCheck;

    public TraitBuilderInterface(Player player, BasicSelectionInterface parent, String traitName, List<TraitConfigOptionContainer> configList, RacesAndClasses plugin) {
        super(player, parent, "Controls", "Trait: " + traitName, (JavaPlugin)plugin);
        this.configList = configList;
        try {
            Class<? extends Trait> traitClass = TraitsList.getClassOfTrait(traitName);
            List<TraitConfigurationField> config = TraitConfigParser.getAllTraitConfigFieldsOfTrait(traitClass);
            for (TraitConfigurationField field : config) {
                boolean skip = false;
                for (TraitConfigOptionContainer container : this.configList) {
                    if (!container.getName().equalsIgnoreCase(field.fieldName())) continue;
                    skip = true;
                }
                if (skip) continue;
                ItemStack item = this.generateItem(Material.ANVIL, ChatColor.RED + field.fieldName(), new LinkedList<String>());
                if (field.optional()) {
                    ItemMetaUtils.addStringToLore(item, ChatColor.YELLOW + "is optional.");
                }
                TraitConfigOptionContainer newContainer = new TraitConfigOptionContainer(field.fieldName(), StatType.getTypeFromClass(field.classToExpect()), item);
                this.configList.add(newContainer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.redraw();
    }

    private void redraw() {
        this.selectionInventory.clear();
        for (TraitConfigOptionContainer option : this.configList) {
            this.selectionInventory.addItem(new ItemStack[]{option.getItem()});
        }
    }

    @Override
    protected boolean onBackPressed() {
        return true;
    }

    @Override
    protected void onAcceptPressed() {
        this.closeAndReturnToParent();
    }

    @Override
    protected void onSelectionItemPressed(ItemStack item) {
        for (TraitConfigOptionContainer traitItem : this.configList) {
            if (!traitItem.getItem().equals((Object)item)) continue;
            String key = traitItem.getName();
            this.tempConfigList.put(key, traitItem.getValue());
            this.optionToCheck = traitItem;
            this.openNewView(StatsSelectionInterfaceFactory.buildInterface(traitItem.getType(), this.player, this, this.tempConfigList, key, this.plugin));
            return;
        }
    }

    @Override
    protected void onControlItemPressed(ItemStack item) {
    }

    @Override
    protected void notifyReopened() {
        super.notifyReopened();
        if (this.optionToCheck == null) {
            return;
        }
        Object newValue = this.tempConfigList.get(this.optionToCheck.getName());
        if (newValue != null) {
            this.optionToCheck.setValue(newValue);
            this.redraw();
        }
    }
}

