/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.racbuilder.gui.holders;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.racbuilder.AbstractHolderBuilder;
import de.tobiyas.racesandclasses.racbuilder.gui.holders.HolderBuildInterface;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.items.ItemMetaUtils;
import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.DoubleSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.StringSelectionInterface;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class HolderGeneralBuilderInterface
extends BasicSelectionInterface {
    private static final String emptyName = "<EMPTY>";
    private static final String NAME_PATH = "name";
    private static final String HEALTH_PATH = "health";
    private static final String TAG_PATH = "tag";
    private final ItemStack nameSelector;
    private final ItemStack healthSelector;
    private final ItemStack tagSelector;
    private final ItemStack traitSelector;
    protected final Map<String, Object> callbackMap = new HashMap<String, Object>();
    protected String currentModifiedValue = null;
    protected final AbstractHolderBuilder builder;

    public HolderGeneralBuilderInterface(Player player, BasicSelectionInterface parent, AbstractHolderBuilder builder, RacesAndClasses plugin) {
        super(player, parent, "Controls", "Build Your Holder", (JavaPlugin)plugin);
        this.builder = builder;
        this.nameSelector = this.generateItem(Material.BAKED_POTATO, ChatColor.RED + "Holder Name: ", emptyName);
        this.tagSelector = this.generateItem(Material.BAKED_POTATO, ChatColor.RED + "Holder Tag: ", emptyName);
        this.healthSelector = this.generateItem(Material.BAKED_POTATO, ChatColor.RED + "Health: ", "");
        this.traitSelector = this.generateItem(Material.ANVIL, ChatColor.RED + "Edit Traits", "");
        this.redraw();
    }

    protected void rebuildFromBuilder() {
        String name = this.builder.getName();
        if (name == null) {
            name = emptyName;
        }
        ItemMetaUtils.replaceLoreWith(this.nameSelector, "Holder Name: " + name);
        String tag = this.builder.getHolderTag();
        if (tag == null) {
            tag = emptyName;
        }
        ItemMetaUtils.replaceLoreWith(this.tagSelector, "Holder Tag: " + tag);
        double health = this.builder.getHealth();
        ItemMetaUtils.replaceLoreWith(this.healthSelector, "Holder health: " + health);
        ItemMetaUtils.replaceLoreWith(this.traitSelector, "Traits:");
        for (Trait trait : this.builder.getTraits()) {
            ItemMetaUtils.addStringToLore(this.traitSelector, trait.getName());
        }
    }

    protected void redraw() {
        this.rebuildFromBuilder();
        this.selectionInventory.setItem(2, this.nameSelector);
        this.selectionInventory.setItem(3, this.tagSelector);
        this.selectionInventory.setItem(5, this.healthSelector);
        this.selectionInventory.setItem(7, this.traitSelector);
    }

    @Override
    protected boolean onBackPressed() {
        return true;
    }

    @Override
    protected void onAcceptPressed() {
        this.builder.setReadyForBuilding(true);
    }

    @Override
    protected void onSelectionItemPressed(ItemStack item) {
        if (this.nameSelector.equals((Object)item)) {
            this.editName();
            return;
        }
        if (this.tagSelector.equals((Object)item)) {
            this.editTag();
            return;
        }
        if (this.healthSelector.equals((Object)item)) {
            this.editHealth();
            return;
        }
        if (this.traitSelector.equals((Object)item)) {
            this.editTraits();
            return;
        }
    }

    private void editName() {
        this.currentModifiedValue = NAME_PATH;
        this.callbackMap.put(this.currentModifiedValue, this.builder.getName());
        this.openNewView(new StringSelectionInterface(this.player, (BasicSelectionInterface)this, this.callbackMap, this.currentModifiedValue, this.plugin));
    }

    private void editTag() {
        this.currentModifiedValue = TAG_PATH;
        this.callbackMap.put(this.currentModifiedValue, this.builder.getName());
        this.openNewView(new StringSelectionInterface(this.player, (BasicSelectionInterface)this, this.callbackMap, this.currentModifiedValue, this.plugin));
    }

    private void editHealth() {
        this.currentModifiedValue = HEALTH_PATH;
        this.callbackMap.put(this.currentModifiedValue, this.builder.getHealth());
        this.openNewView(new DoubleSelectionInterface(this.player, (BasicSelectionInterface)this, this.callbackMap, this.currentModifiedValue, this.plugin));
    }

    private void editTraits() {
        this.currentModifiedValue = null;
        this.openNewView(new HolderBuildInterface(this.player, this, this.builder, (RacesAndClasses)this.plugin));
    }

    @Override
    protected void onControlItemPressed(ItemStack item) {
    }

    @Override
    protected void notifyReopened() {
        super.notifyReopened();
        if (this.currentModifiedValue == null) {
            return;
        }
        if (this.currentModifiedValue == NAME_PATH) {
            String newName = (String)this.callbackMap.get(NAME_PATH);
            this.builder.setName(newName);
            this.redraw();
            return;
        }
        if (this.currentModifiedValue == TAG_PATH) {
            String newTag = (String)this.callbackMap.get(TAG_PATH);
            this.builder.setHolderTag(newTag);
            this.redraw();
            return;
        }
        if (this.currentModifiedValue == HEALTH_PATH) {
            double newHealth = (Double)this.callbackMap.get(HEALTH_PATH);
            this.builder.setHealth(newHealth);
            this.redraw();
            return;
        }
    }
}

