/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.racbuilder.gui.holders;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.racbuilder.AbstractHolderBuilder;
import de.tobiyas.racesandclasses.racbuilder.gui.trait.TraitBuilderInterface;
import de.tobiyas.racesandclasses.racbuilder.gui.trait.TraitConfigOptionContainer;
import de.tobiyas.racesandclasses.traitcontainer.container.TraitsList;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.items.ItemMetaUtils;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.elements.ScrollableItems;
import de.tobiyas.util.RaC.inventorymenu.stats.StatType;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class HolderBuildInterface
extends BasicSelectionInterface {
    protected ScrollableItems holderTraits;
    protected ScrollableItems possibleTraits;
    protected final AbstractHolderBuilder builder;
    protected List<TraitConfigOptionContainer> currentTraitEditingList;
    protected String currentTraitName;

    public HolderBuildInterface(Player player, BasicSelectionInterface parent, AbstractHolderBuilder builder, RacesAndClasses plugin) {
        super(player, parent, plugin);
        this.builder = builder;
        this.holderTraits = new ScrollableItems(this.selectionInventory, 0, 8, 0);
        this.possibleTraits = new ScrollableItems(this.controlInventory, 0, 8, 1);
        this.populateFromBuilder();
    }

    private void populateFromBuilder() {
        this.possibleTraits.clear();
        this.holderTraits.clear();
        LinkedList<Object> itemsToAdd = new LinkedList<ItemStack>();
        for (Trait trait : this.builder.getTraits()) {
            ItemStack traitItem = new ItemStack(Material.SKULL_ITEM);
            ItemMetaUtils.setDisplayNameOfItem(traitItem, ChatColor.RED + trait.getName());
            List<String> helpList = new LinkedList<String>();
            try {
                Class<? extends Trait> clazz = TraitsList.getClassOfTrait(trait.getName());
                if (clazz == null) break;
                helpList = (List)clazz.getMethod("getHelpForTrait", new Class[0]).invoke(clazz, new Object[0]);
            }
            catch (Exception exp) {
                helpList.add("No help found.");
            }
            for (String line : helpList) {
                ItemMetaUtils.addStringToLore(traitItem, line);
            }
            ItemMetaUtils.addStringToLore(traitItem, "ConfigTotal:");
            ItemMetaUtils.addStringToLore(traitItem, trait.getPrettyConfiguration());
            itemsToAdd.add(traitItem);
        }
        this.holderTraits.addItems(itemsToAdd);
        itemsToAdd = new LinkedList();
        LinkedList<String> alreadyPresentInList = new LinkedList<String>();
        for (String traitName : TraitsList.getAllVisibleTraits()) {
            boolean skip = false;
            for (ItemStack item : this.holderTraits.getAllItems()) {
                if (!item.getItemMeta().hasDisplayName() || !item.getItemMeta().getDisplayName().contains(traitName)) continue;
                skip = true;
                break;
            }
            if (skip || alreadyPresentInList.contains(traitName)) continue;
            List helpList = new LinkedList<String>();
            try {
                Class<? extends Trait> clazz = TraitsList.getClassOfTrait(traitName);
                if (clazz == null) break;
                helpList = (List)clazz.getMethod("getHelpForTrait", new Class[0]).invoke(clazz, new Object[0]);
            }
            catch (Exception exp) {
                helpList.add("No help found.");
            }
            ItemStack traitItem = new ItemStack(Material.SKULL_ITEM);
            ItemMetaUtils.setDisplayNameOfItem(traitItem, ChatColor.RED + traitName);
            for (String helpString : helpList) {
                ItemMetaUtils.addStringToLore(traitItem, helpString);
            }
            itemsToAdd.add(traitItem);
            alreadyPresentInList.add(traitName);
        }
        this.possibleTraits.addItems(itemsToAdd);
    }

    @Override
    protected boolean onBackPressed() {
        return true;
    }

    @Override
    protected void onAcceptPressed() {
        this.performSave();
        this.closeAndReturnToParent();
    }

    private void performSave() {
        this.builder.setReadyForBuilding(true);
    }

    @Override
    protected void onSelectionItemPressed(ItemStack item) {
        if (this.holderTraits.checkScrollButtons(item)) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            String traitName = meta.getDisplayName();
            traitName = traitName.substring(2, traitName.length());
            for (Trait trait : this.builder.getTraits()) {
                if (!trait.getName().equalsIgnoreCase(traitName)) continue;
                this.currentTraitEditingList = this.loadFromTrait(trait);
                this.currentTraitName = trait.getName();
                this.openNewView(new TraitBuilderInterface(this.player, (BasicSelectionInterface)this, trait.getName(), this.currentTraitEditingList, (RacesAndClasses)this.plugin));
                return;
            }
        }
    }

    private List<TraitConfigOptionContainer> loadFromTrait(Trait trait) {
        LinkedList<TraitConfigOptionContainer> configOptions = new LinkedList<TraitConfigOptionContainer>();
        if (!(trait instanceof AbstractBasicTrait)) {
            return configOptions;
        }
        TraitConfiguration traitconfigMap = trait.getCurrentconfig();
        if (traitconfigMap == null) {
            return configOptions;
        }
        for (String key : traitconfigMap.keySet()) {
            Object value = traitconfigMap.get(key);
            ItemStack item = this.generateItem(Material.ANVIL, key, value.toString());
            TraitConfigOptionContainer newOptions = new TraitConfigOptionContainer(key, StatType.getTypeFromClass(value.getClass()), item);
            newOptions.setValue(value);
            configOptions.add(newOptions);
        }
        return configOptions;
    }

    @Override
    protected void onControlItemPressed(ItemStack item) {
        if (this.possibleTraits.checkScrollButtons(item)) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            String traitName = meta.getDisplayName();
            this.currentTraitName = traitName = traitName.substring(2, traitName.length());
            this.currentTraitEditingList = new LinkedList<TraitConfigOptionContainer>();
            this.openNewView(new TraitBuilderInterface(this.player, (BasicSelectionInterface)this, traitName, this.currentTraitEditingList, (RacesAndClasses)this.plugin));
        }
    }

    @Override
    protected void notifyReopened() {
        super.notifyReopened();
        TraitConfiguration configMap = new TraitConfiguration(null);
        for (TraitConfigOptionContainer container : this.currentTraitEditingList) {
            if (!container.isValueSet()) {
                return;
            }
            configMap.put(container.getName(), container.getValue());
        }
        this.builder.addTrait(this.currentTraitName, configMap);
        this.populateFromBuilder();
    }
}

