/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.racbuilder.gui.holders;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.racbuilder.AbstractHolderBuilder;
import de.tobiyas.racesandclasses.racbuilder.ClassHolderBuilder;
import de.tobiyas.racesandclasses.racbuilder.gui.holders.HolderGeneralBuilderInterface;
import de.tobiyas.racesandclasses.util.items.ItemMetaUtils;
import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.OperatorSelectionInterface;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ClassGeneralBuilderInterface
extends HolderGeneralBuilderInterface {
    private static final String HEALTH_OPERATOR_PATH = "health_operator";
    private final ItemStack healthOperationSelector = this.generateItem(Material.BAKED_POTATO, ChatColor.RED + "Health Operator", ChatColor.LIGHT_PURPLE + "Value : ");

    public ClassGeneralBuilderInterface(Player player, BasicSelectionInterface parent, AbstractHolderBuilder builder, RacesAndClasses plugin) {
        super(player, parent, builder, plugin);
    }

    @Override
    protected void rebuildFromBuilder() {
        super.rebuildFromBuilder();
        ClassHolderBuilder classBuilder = (ClassHolderBuilder)this.builder;
        String operation = classBuilder.getHealthOperation();
        ItemMetaUtils.replaceLoreWith(this.healthOperationSelector, "Value: " + operation);
    }

    @Override
    protected void redraw() {
        super.redraw();
    }

    @Override
    protected void onSelectionItemPressed(ItemStack item) {
        super.onSelectionItemPressed(item);
        if (this.healthOperationSelector.equals((Object)item)) {
            this.editHealthOperation();
            return;
        }
    }

    private void editHealthOperation() {
        this.currentModifiedValue = HEALTH_OPERATOR_PATH;
        ClassHolderBuilder classBuilder = (ClassHolderBuilder)this.builder;
        this.callbackMap.put(this.currentModifiedValue, classBuilder.getHealthOperation());
        this.openNewView(new OperatorSelectionInterface(this.player, (BasicSelectionInterface)this, this.callbackMap, this.currentModifiedValue, this.plugin));
    }
}

