/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.racbuilder.gui.holdermanager;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractHolderManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.racbuilder.AbstractHolderBuilder;
import de.tobiyas.racesandclasses.racbuilder.gui.holdermanager.HolderItemContainer;
import de.tobiyas.racesandclasses.racbuilder.gui.holders.HolderGeneralBuilderInterface;
import de.tobiyas.racesandclasses.racbuilder.gui.holders.HolderSelectionState;
import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class HolderSelectionInterface
extends BasicSelectionInterface {
    private final int currentStateField = 32;
    protected final ItemStack addHolderSelector;
    protected final ItemStack editHolderSelector;
    protected final ItemStack removeHolderSelector;
    protected final ItemStack currentStateIndicator;
    protected AbstractHolderBuilder builder;
    protected final AbstractHolderManager holderManager;
    protected final List<HolderItemContainer> holderContainers;
    protected HolderSelectionState currentState = HolderSelectionState.EDIT;

    public HolderSelectionInterface(Player player, BasicSelectionInterface parent, AbstractHolderManager holderManager, RacesAndClasses plugin) {
        super(player, parent, "Controls", holderManager.getContainerTypeAsString(), (JavaPlugin)plugin);
        this.holderManager = holderManager;
        this.holderContainers = new LinkedList<HolderItemContainer>();
        String holderTypeName = holderManager.getContainerTypeAsString();
        this.addHolderSelector = this.generateItem(Material.DIAMOND, ChatColor.GREEN + "Add " + holderTypeName, ChatColor.LIGHT_PURPLE + "Adds a new " + holderTypeName);
        this.editHolderSelector = this.generateItem(Material.SPONGE, ChatColor.YELLOW + "Edit " + holderTypeName, ChatColor.LIGHT_PURPLE + "Edits an existing " + holderTypeName);
        this.removeHolderSelector = this.generateItem(Material.FIRE, ChatColor.RED + "Remove " + holderTypeName, ChatColor.LIGHT_PURPLE + "Removes an existing " + holderTypeName);
        this.currentStateIndicator = this.generateItem(Material.SPONGE, ChatColor.AQUA + "Current Operation", new LinkedList<String>());
        this.controlInventory.setItem(2, this.addHolderSelector);
        this.controlInventory.setItem(5, this.editHolderSelector);
        this.controlInventory.setItem(6, this.removeHolderSelector);
        this.controlInventory.setItem(32, this.currentStateIndicator);
        this.createHolders();
        this.redrawHolderList();
    }

    private void createHolders() {
        for (String holderName : this.holderManager.listAllVisibleHolders()) {
            AbstractTraitHolder holder = this.holderManager.getHolderByName(holderName);
            AbstractHolderBuilder builder = this.generateHolderBuilderFor(holder);
            if (holder == null) continue;
            HolderItemContainer container = new HolderItemContainer(builder);
            container.getBuilder().setReadyForBuilding(true);
            this.holderContainers.add(container);
        }
    }

    private void redrawHolderList() {
        this.selectionInventory.clear();
        LinkedList<HolderItemContainer> toRemove = new LinkedList<HolderItemContainer>();
        for (HolderItemContainer container : this.holderContainers) {
            if (!container.getBuilder().isReadyForBuilding()) {
                toRemove.add(container);
                continue;
            }
            if (container == null) continue;
            container.rebuildItem();
            this.selectionInventory.addItem(new ItemStack[]{container.getItemRepresentation()});
        }
        for (HolderItemContainer remove : toRemove) {
            this.holderContainers.remove(remove);
        }
    }

    @Override
    protected boolean onBackPressed() {
        return true;
    }

    @Override
    protected void onAcceptPressed() {
        this.saveBuilders();
    }

    private void saveBuilders() {
        for (HolderItemContainer holder : this.holderContainers) {
            AbstractHolderBuilder builder = holder.getBuilder();
            builder.saveToFile();
        }
    }

    @Override
    protected void onSelectionItemPressed(ItemStack item) {
        for (HolderItemContainer holder : this.holderContainers) {
            if (!holder.getItemRepresentation().equals((Object)item) || !holder.getBuilder().isReadyForBuilding()) continue;
            this.holderPressed(holder);
        }
    }

    @Override
    protected void onControlItemPressed(ItemStack item) {
        if (item.equals((Object)this.currentStateIndicator)) {
            return;
        }
        if (item.equals((Object)this.addHolderSelector)) {
            this.scheduleAdd();
            return;
        }
        if (item.equals((Object)this.editHolderSelector)) {
            this.changeState(HolderSelectionState.EDIT);
            return;
        }
        if (item.equals((Object)this.removeHolderSelector)) {
            this.changeState(HolderSelectionState.REMOVE);
            return;
        }
    }

    private void changeState(HolderSelectionState newState) {
        if (newState == this.currentState) {
            return;
        }
        this.currentState = newState;
        switch (newState) {
            case REMOVE: {
                this.currentStateIndicator.setType(this.removeHolderSelector.getType());
                break;
            }
            case EDIT: {
                this.currentStateIndicator.setType(this.editHolderSelector.getType());
            }
        }
        this.controlInventory.setItem(32, null);
        this.controlInventory.setItem(32, this.currentStateIndicator);
    }

    private void holderPressed(HolderItemContainer container) {
        switch (this.currentState) {
            case EDIT: {
                this.editHolder(container);
                break;
            }
            case REMOVE: {
                this.removeHolder(container);
            }
        }
    }

    private void editHolder(HolderItemContainer holder) {
        this.builder = holder.getBuilder();
        this.openNewView(new HolderGeneralBuilderInterface(this.player, this, this.builder, (RacesAndClasses)this.plugin));
    }

    private void removeHolder(HolderItemContainer holder) {
        this.holderContainers.remove(holder);
        this.redrawHolderList();
    }

    private void scheduleAdd() {
        this.builder = this.generateNewHolderBuilder("<No Name>");
        HolderItemContainer container = new HolderItemContainer(this.builder);
        this.holderContainers.add(container);
        this.openNewView(new HolderGeneralBuilderInterface(this.player, this, this.builder, (RacesAndClasses)this.plugin));
    }

    protected abstract AbstractHolderBuilder generateNewHolderBuilder(String var1);

    protected abstract AbstractHolderBuilder generateHolderBuilderFor(AbstractTraitHolder var1);

    @Override
    protected void notifyReopened() {
        if (this.builder != null && this.builder.isReadyForBuilding()) {
            this.redrawHolderList();
            this.builder = null;
        }
    }
}

