/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.racbuilder;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.traitcontainer.TraitStore;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.items.ItemUtils;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractHolderBuilder {
    protected String name;
    protected String holderTag;
    protected final Set<Trait> traitSet;
    protected final List<String> permissionList;
    protected Set<ItemUtils.ItemQuality> armorPermission;
    protected final RacesAndClasses plugin = RacesAndClasses.getPlugin();
    protected boolean readyForBuilding = false;
    protected double health;

    public AbstractHolderBuilder(String name) {
        this.name = name;
        if (name != null) {
            this.holderTag = "[" + name + "]";
        }
        this.armorPermission = new HashSet<ItemUtils.ItemQuality>();
        this.traitSet = new HashSet<Trait>();
        this.permissionList = new LinkedList<String>();
    }

    public AbstractHolderBuilder(AbstractTraitHolder holder) {
        this.name = holder.getDisplayName();
        this.holderTag = holder.getTag();
        this.armorPermission = holder.getArmorPerms();
        this.traitSet = holder.getVisibleTraits();
        this.permissionList = new LinkedList<String>();
    }

    public boolean addPermissionNode(String permissionNode) {
        if (permissionNode == null) {
            return false;
        }
        return this.permissionList.add(permissionNode);
    }

    public boolean removePermissionNode(String permissionNode) {
        if (permissionNode == null) {
            return false;
        }
        return this.permissionList.remove(permissionNode);
    }

    public boolean addTrait(String traitName, TraitConfiguration configuration) {
        Trait trait;
        block4: {
            if (this.containsTrait(traitName)) {
                this.removeTrait(traitName);
            }
            try {
                trait = TraitStore.buildTraitWithoutHolderByName(traitName);
                if (trait != null) break block4;
                return false;
            }
            catch (Exception exp) {
                exp.printStackTrace();
                return false;
            }
        }
        trait.setConfiguration(configuration);
        this.traitSet.add(trait);
        return true;
    }

    public boolean removeTrait(String traitName) {
        if (!this.containsTrait(traitName)) {
            return false;
        }
        Trait trait = this.getTrait(traitName);
        this.traitSet.remove(trait);
        return true;
    }

    private Trait getTrait(String traitName) {
        for (Trait trait : this.traitSet) {
            if (!trait.getName().equalsIgnoreCase(traitName)) continue;
            return trait;
        }
        return null;
    }

    public boolean containsTrait(String traitName) {
        return this.getTrait(traitName) != null;
    }

    public void setHolderTag(String holderTag) {
        this.holderTag = holderTag;
    }

    public void addArmor(String armorString) {
        this.setArmor(armorString, true);
    }

    public void removeArmor(String armorString) {
        this.setArmor(armorString, false);
    }

    protected void setArmor(String armorString, boolean toSet) {
        Collection<ItemUtils.ItemQuality> stuff = ItemUtils.ItemQuality.parse(armorString);
        if (toSet) {
            this.armorPermission.addAll(stuff);
        } else {
            this.armorPermission.removeAll(stuff);
        }
    }

    public boolean isReadyForBuilding() {
        return this.readyForBuilding;
    }

    public void setReadyForBuilding(boolean ready) {
        this.readyForBuilding = ready;
    }

    public abstract AbstractTraitHolder build();

    public Set<Trait> getTraits() {
        return this.traitSet;
    }

    public String getName() {
        return this.name;
    }

    public String getHolderTag() {
        return this.holderTag;
    }

    public void setName(String name) {
        this.name = name;
        if (this.holderTag == null && name != null) {
            this.holderTag = "[" + name + "]";
        }
    }

    public double getHealth() {
        return this.health;
    }

    public void setHealth(double health) {
        this.health = health;
    }

    public void saveToFile() {
        if (!this.isReadyForBuilding()) {
            return;
        }
        YAMLConfigExtended holderConfig = this.getHolderYAMLFile();
        if (!holderConfig.isConfigurationSection(this.name)) {
            holderConfig.createSection(this.name);
        }
        if (!holderConfig.isConfigurationSection(String.valueOf(this.name) + ".config")) {
            holderConfig.createSection(String.valueOf(this.name) + ".config");
        }
        if (this.traitSet.size() > 0 && !holderConfig.isConfigurationSection(String.valueOf(this.name) + ".traits")) {
            holderConfig.createSection(String.valueOf(this.name) + ".traits");
        }
        for (Trait trait : this.traitSet) {
            holderConfig.createSection(String.valueOf(this.name) + ".traits." + trait.getName());
            for (String key : trait.getCurrentconfig().keySet()) {
                Object value = trait.getCurrentconfig().get(key);
                holderConfig.set(String.valueOf(this.name) + ".traits." + trait.getName() + "." + key, value);
            }
        }
        String armorString = this.buildArmorString();
        if (armorString.length() > 0) {
            holderConfig.set(String.valueOf(this.name) + ".config.armor", armorString);
        }
        this.saveFurtherToFile(holderConfig);
        holderConfig.save();
    }

    protected String buildArmorString() {
        boolean hasAll = ItemUtils.ItemQuality.values().size() == this.armorPermission.size();
        String armorString = "";
        for (ItemUtils.ItemQuality quality : this.armorPermission) {
            armorString = String.valueOf(armorString) + quality + ",";
        }
        if (hasAll) {
            armorString = "all";
        }
        return armorString;
    }

    protected abstract void saveFurtherToFile(YAMLConfigExtended var1);

    protected abstract YAMLConfigExtended getHolderYAMLFile();
}

