/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.spellmanagement.mana.impl;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.mana.ManaFoodBarRunner;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.mana.impl.AbstractManaManager;

public class OwnManaManager
extends AbstractManaManager {
    private double currentMana = 0.0;
    private final ManaFoodBarRunner foodBar = new ManaFoodBarRunner(this);

    public OwnManaManager(RaCPlayer player) {
        super(player);
        this.foodBar.start();
    }

    @Override
    public void rescanPlayer() {
        super.rescanPlayer();
        this.currentMana = Math.min(this.getMaxMana(), this.currentMana);
    }

    @Override
    public double fillMana(double value) {
        this.currentMana += value;
        if (this.currentMana > this.getMaxMana()) {
            this.currentMana = this.getMaxMana();
        }
        return this.currentMana;
    }

    @Override
    public double drownMana(double value) {
        this.currentMana -= value;
        if (this.currentMana < 0.0) {
            this.currentMana = 0.0;
        }
        return this.currentMana;
    }

    @Override
    public double getMaxMana() {
        double max = 0.0;
        for (Double value : this.maxManaBonusses.values()) {
            max += value.doubleValue();
        }
        return max;
    }

    @Override
    public double getCurrentMana() {
        return this.currentMana;
    }

    @Override
    protected void applyMaxManaBonus(double bonus) {
    }

    @Override
    public double getManaBoostByName(String boostID) {
        Double amount = (Double)this.maxManaBonusses.get(boostID);
        return amount == null ? 0.0 : amount;
    }
}

