/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.spellmanagement.mana.impl;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers.WorldResolver;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.mana.ManaManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithCost;
import de.tobiyas.util.RaC.formating.StringFormatUtils;
import de.tobiyas.util.RaC.math.Math2;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;

public abstract class AbstractManaManager
implements ManaManager {
    protected final RaCPlayer racPlayer;
    protected RacesAndClasses plugin = RacesAndClasses.getPlugin();
    protected final Map<String, Double> maxManaBonusses = new HashMap<String, Double>();

    public AbstractManaManager(RaCPlayer racPlayer) {
        this.racPlayer = racPlayer;
    }

    @Override
    public void rescanPlayer() {
        ClassContainer clazz;
        if (this.racPlayer == null || !this.racPlayer.isOnline() || WorldResolver.isOnDisabledWorld(this.racPlayer)) {
            return;
        }
        int level = this.racPlayer.getLevelManager().getCurrentLevel();
        RaceContainer race = this.racPlayer.getRace();
        if (race != null && race.getManaBonus(level) > 0.0) {
            this.addMaxManaBonus("race", race.getManaBonus(level));
        }
        if ((clazz = this.racPlayer.getclass()) != null && clazz.getManaBonus(level) > 0.0) {
            this.addMaxManaBonus("class", clazz.getManaBonus(level));
        }
    }

    @Override
    public boolean playerCastSpell(TraitWithCost spellToCast) {
        if (!this.hasEnoughMana(spellToCast)) {
            return false;
        }
        this.drownMana(spellToCast.getCost(this.racPlayer));
        return true;
    }

    @Override
    public boolean hasEnoughMana(TraitWithCost spell) {
        return this.hasEnoughMana(spell.getCost(this.racPlayer));
    }

    @Override
    public boolean hasEnoughMana(double manaNeeded) {
        return this.getCurrentMana() >= manaNeeded;
    }

    @Override
    public void addMaxManaBonus(String key, double value) {
        this.maxManaBonusses.put(key, value);
        double bonus = 0.0;
        for (Double val : this.maxManaBonusses.values()) {
            bonus += val.doubleValue();
        }
        this.applyMaxManaBonus(bonus);
    }

    @Override
    public void removeMaxManaBonus(String key) {
        this.maxManaBonusses.remove(key);
        double bonus = 0.0;
        for (Double value : this.maxManaBonusses.values()) {
            bonus += value.doubleValue();
        }
        this.applyMaxManaBonus(bonus);
    }

    @Override
    public void tick() {
        double maxMana = this.getMaxMana();
        if (maxMana <= 0.0) {
            maxMana = 0.1;
        }
        double percent = Math2.clamp(0.0, this.getCurrentMana() / this.getMaxMana(), 1.0);
        String line = StringFormatUtils.formatToPercent(percent, 10, '\u220e', ChatColor.BLUE, ChatColor.WHITE);
        line = String.valueOf(ChatColor.DARK_BLUE.toString()) + '\u2739' + " {" + line + ChatColor.DARK_BLUE + "}";
        this.racPlayer.getActionbarDisplay().setSegment("manabar", line);
        this.racPlayer.getActionbarDisplay().setSegment("mana", "" + this.getCurrentMana());
        this.racPlayer.getActionbarDisplay().setSegment("maxmana", "" + this.getMaxMana());
    }

    protected abstract void applyMaxManaBonus(double var1);

    @Override
    public Map<String, Double> getAllBonuses() {
        return new HashMap<String, Double>(this.maxManaBonusses);
    }

    @Override
    public RaCPlayer getPlayer() {
        return this.racPlayer;
    }

    @Override
    public boolean isManaFull() {
        return this.getCurrentMana() >= this.getMaxMana();
    }
}

