/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.spellmanagement.mana;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers.WorldResolver;
import de.tobiyas.racesandclasses.eventprocessing.events.mana.ManaRegenerationEvent;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.mana.ManaManager;
import de.tobiyas.racesandclasses.util.traitutil.TraitRegionChecker;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import de.tobiyas.util.RaC.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ManaFoodBarRunner
extends DebugBukkitRunnable
implements Listener {
    private final ManaManager manaManager;
    private final RacesAndClasses plugin;
    private int sprintTick = 0;
    private boolean isSprinting = false;

    public ManaFoodBarRunner(ManaManager manaManager) {
        super("ManaFoodbarRunner");
        this.manaManager = manaManager;
        this.plugin = RacesAndClasses.getPlugin();
    }

    public void start() {
        this.runTaskTimer((Plugin)RacesAndClasses.getPlugin(), 10L, 10L);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RacesAndClasses.getPlugin());
    }

    @Override
    protected void runIntern() {
        if (this.isSprinting) {
            if (this.manaManager.getPlayer().getGameMode() != GameMode.SURVIVAL) {
                this.isSprinting = false;
            } else {
                ++this.sprintTick;
            }
            int eventyTicksMana = this.plugin.getConfigManager().getGeneralConfig().getConfig_magic_sprintingManaDrainInterval() * 2;
            if (this.sprintTick >= eventyTicksMana) {
                double howMany = this.plugin.getConfigManager().getGeneralConfig().getConfig_magic_sprintingManaCost();
                if (howMany > 0.0 || this.manaManager.getPlayer().getGameMode() == GameMode.SURVIVAL) {
                    this.manaManager.drownMana(howMany);
                    VollotileCodeManager.getVollotileCode().sendParticleEffect(ParticleEffects.ENCHANTMENT_TABLE, this.manaManager.getPlayer().getLocation(), new Vector(0.2, 0.0, 0.2), 1.0f, 4, this.manaManager.getPlayer().getPlayer());
                }
                this.sprintTick = 0;
            }
        }
        if (!this.isActive()) {
            return;
        }
        Player player = this.manaManager.getPlayer().getPlayer();
        player.setFoodLevel(this.getLevel());
        player.setSaturation(20.0f);
        if (this.plugin.getConfigManager().getGeneralConfig().getConfig_magic_sprintingManaCost() > 0.0 && player.getFoodLevel() <= 2 && player.isSprinting()) {
            this.isSprinting = false;
            player.setSprinting(false);
        }
    }

    private int getLevel() {
        double current = this.manaManager.getCurrentMana();
        double max = this.manaManager.getMaxMana();
        if (max == 0.0) {
            return 1;
        }
        double percent = current / max;
        int calcedLevel = (int)Math.floor(percent * 20.0);
        if (current == 0.0) {
            calcedLevel = 0;
        }
        return calcedLevel;
    }

    private boolean isActive() {
        return this.plugin.getConfigManager().getGeneralConfig().isConfig_useFoodManaBar() && this.manaManager.getPlayer().isOnline();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void foodLevelChange(FoodLevelChangeEvent event) {
        if (!this.isActive()) {
            return;
        }
        if (!TraitRegionChecker.isInDisabledLocation(event.getEntity().getLocation())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void damageByFoodlevel(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.STARVATION) {
            return;
        }
        if (!event.getEntity().getUniqueId().equals(this.manaManager.getPlayer().getUniqueId())) {
            return;
        }
        if (!this.isActive()) {
            return;
        }
        if (!WorldResolver.isDisabledWorld(event.getEntity().getWorld())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void healByFoodlevel(EntityRegainHealthEvent event) {
        if (event.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED) {
            return;
        }
        if (!event.getEntity().getUniqueId().equals(this.manaManager.getPlayer().getUniqueId())) {
            return;
        }
        if (!this.isActive()) {
            return;
        }
        if (!WorldResolver.isDisabledWorld(event.getEntity().getWorld())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerStartsSprinting(PlayerToggleSprintEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().getConfig_magic_sprintingManaCost() <= 0.0) {
            return;
        }
        if (!event.getPlayer().getUniqueId().equals(this.manaManager.getPlayer().getUniqueId())) {
            return;
        }
        this.isSprinting = event.isSprinting();
        if (this.isSprinting && this.manaManager.getCurrentMana() <= 2.0) {
            event.setCancelled(true);
            this.isSprinting = false;
        }
    }

    @EventHandler
    public void playerGainsMana(ManaRegenerationEvent event) {
        if (!event.getPlayer().getUniqueId().equals(this.manaManager.getPlayer().getUniqueId())) {
            return;
        }
        if (this.plugin.getConfigManager().getGeneralConfig().getConfig_magic_manaRefillWhileSprinting()) {
            return;
        }
        if (event.getPlayer().isSprinting()) {
            event.setCancelled(true);
            event.setAmount(0.0);
        }
    }

    @EventHandler
    public void playerLeave(PlayerQuitEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().getConfig_magic_sprintingManaCost() <= 0.0) {
            return;
        }
        if (!event.getPlayer().getUniqueId().equals(this.manaManager.getPlayer().getUniqueId())) {
            return;
        }
        this.isSprinting = false;
    }
}

