/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.spellmanagement;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers.WorldResolver;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.RotatableList;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.mana.ManaManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.MagicSpellTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithCost;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithRestrictions;
import de.tobiyas.racesandclasses.util.items.WandItem;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class PlayerSpellManager {
    private long lastEventTime = System.currentTimeMillis();
    private final RaCPlayer player;
    protected final ManaManager manaManager;
    protected final RotatableList<MagicSpellTrait> spellList;

    public PlayerSpellManager(RaCPlayer player) {
        this.player = player;
        this.manaManager = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_manaManagerType().generate(player);
        this.spellList = new RotatableList();
    }

    public void rescan() {
        MagicSpellTrait current = this.getCurrentSpell();
        this.spellRescan();
        this.manaManager.rescanPlayer();
        if (current != null) {
            this.selectSpell(current.getDisplayName());
        }
    }

    private void selectSpell(String displayName) {
        int i = 0;
        while (i < this.spellList.size()) {
            boolean canUse;
            MagicSpellTrait next = this.spellList.next();
            if (next instanceof TraitWithRestrictions && (canUse = next.isInLevelRange(this.player.getLevelManager().getCurrentLevel())) && next.getDisplayName().equalsIgnoreCase(displayName)) {
                return;
            }
            ++i;
        }
    }

    private void spellRescan() {
        LinkedList<MagicSpellTrait> spellList = new LinkedList<MagicSpellTrait>();
        if (this.player == null || !this.player.isOnline() || WorldResolver.isOnDisabledWorld(this.player.getPlayer())) {
            this.spellList.setEntries(spellList);
            return;
        }
        Set<Trait> traits = TraitHolderCombinder.getSkillTreeReducedTraitsOfPlayer(this.player);
        for (Trait trait : traits) {
            if (!(trait instanceof MagicSpellTrait)) continue;
            spellList.add((MagicSpellTrait)trait);
        }
        Collections.sort(spellList);
        this.spellList.setEntries(spellList);
    }

    public MagicSpellTrait changeToNextSpell() {
        if (this.spellList.size() == 0) {
            return null;
        }
        if (System.currentTimeMillis() - this.lastEventTime < 100L) {
            return null;
        }
        this.lastEventTime = System.currentTimeMillis();
        int i = 0;
        while (i < this.spellList.size()) {
            MagicSpellTrait next = this.spellList.next();
            if (next instanceof TraitWithRestrictions) {
                boolean canUse = next.isInLevelRange(this.player.getLevelManager().getCurrentLevel());
                if (canUse) {
                    return next;
                }
            } else {
                return next;
            }
            ++i;
        }
        return null;
    }

    public TraitWithCost changeToPrevSpell() {
        if (this.spellList.size() == 0) {
            return null;
        }
        if (System.currentTimeMillis() - this.lastEventTime < 100L) {
            return null;
        }
        this.lastEventTime = System.currentTimeMillis();
        int i = 0;
        while (i < this.spellList.size()) {
            TraitWithCost next = this.spellList.previous();
            if (next instanceof TraitWithRestrictions) {
                boolean canUse = ((TraitWithRestrictions)((Object)next)).isInLevelRange(this.player.getLevelManager().getCurrentLevel());
                if (canUse) {
                    return next;
                }
            } else {
                return next;
            }
            ++i;
        }
        return null;
    }

    public List<MagicSpellTrait> getAllSpells() {
        List<MagicSpellTrait> spells = this.spellList.getAllEntries();
        Iterator<MagicSpellTrait> it = spells.iterator();
        while (it.hasNext()) {
            if (it.next().isInLevelRange(this.player.getLevelManager().getCurrentLevel())) continue;
            it.remove();
        }
        return spells;
    }

    public ManaManager getManaManager() {
        return this.manaManager;
    }

    public MagicSpellTrait getCurrentSpell() {
        boolean canUse;
        MagicSpellTrait current = this.spellList.currentEntry();
        if (current == null) {
            return this.changeToNextSpell();
        }
        if (current instanceof TraitWithRestrictions && !(canUse = current.isInLevelRange(this.player.getLevelManager().getCurrentLevel()))) {
            return this.changeToNextSpell();
        }
        return current;
    }

    public void tick() {
        this.manaManager.tick();
    }

    public boolean canCastSpell(TraitWithCost trait) {
        double cost = trait.getCost(this.player);
        switch (trait.getCostType()) {
            case HEALTH: {
                return this.player.getHealth() > cost;
            }
            case MANA: {
                return this.getManaManager().hasEnoughMana(cost);
            }
            case ITEM: {
                return this.playerHasItem(trait.getCastMaterialType(this.player), trait.getCastMaterialDamage(this.player), trait.getCastMaterialName(this.player), (int)cost);
            }
            case HUNGER: {
                return (double)this.player.getPlayer().getFoodLevel() >= cost;
            }
            case EXP: {
                return this.player.getLevelManager().canRemove((int)cost);
            }
        }
        return false;
    }

    private boolean playerHasItem(Material material, short damage, String name, int amount) {
        if (!this.player.isOnline()) {
            return false;
        }
        if (name != null) {
            name = ChatColor.stripColor((String)name);
        }
        Player player = this.player.getPlayer();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv) {
            if (item == null || item.getType() != material || item.getDurability() != damage) continue;
            if (name != null && !name.isEmpty()) {
                if (!item.getItemMeta().hasDisplayName()) continue;
                String itemName = item.getItemMeta().getDisplayName();
                if (!(itemName = ChatColor.stripColor((String)itemName)).equalsIgnoreCase(name)) continue;
            }
            if ((amount -= item.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    private void removeItem(Material material, short damage, String name, int amount) {
        if (!this.player.isOnline()) {
            return;
        }
        if (name != null) {
            name = ChatColor.stripColor((String)name);
        }
        Player player = this.player.getPlayer();
        PlayerInventory inv = player.getInventory();
        int i = 0;
        while (i < inv.getSize()) {
            block7: {
                ItemStack item;
                block8: {
                    item = inv.getItem(i);
                    if (item == null || item.getType() != material || item.getDurability() != damage) break block7;
                    if (name == null || name.isEmpty()) break block8;
                    if (!item.getItemMeta().hasDisplayName()) break block7;
                    String itemName = item.getItemMeta().getDisplayName();
                    if (!(itemName = ChatColor.stripColor((String)itemName)).equalsIgnoreCase(name)) break block7;
                }
                int newAmount = item.getAmount() - amount;
                item.setAmount(newAmount);
                inv.setItem(i, item);
                amount = -newAmount;
                if (amount <= 0) {
                    return;
                }
            }
            ++i;
        }
    }

    public void removeCost(TraitWithCost trait) {
        double cost = trait.getCost(this.player);
        switch (trait.getCostType()) {
            case HEALTH: {
                this.player.getHealthManager().damage(cost);
                break;
            }
            case MANA: {
                this.getManaManager().drownMana(cost);
                break;
            }
            case ITEM: {
                this.removeItem(trait.getCastMaterialType(this.player), trait.getCastMaterialDamage(this.player), trait.getCastMaterialName(this.player), (int)cost);
                break;
            }
            case HUNGER: {
                int oldFoodLevel = this.player.getPlayer().getFoodLevel();
                int newFoodLevel = (int)((double)oldFoodLevel - cost);
                this.player.getPlayer().setFoodLevel(newFoodLevel < 0 ? 0 : newFoodLevel);
            }
            case EXP: {
                this.player.getLevelManager().removeExp((int)cost);
            }
        }
    }

    public int getSpellAmount() {
        return this.spellList.size();
    }

    public boolean changeToSpell(String spellName) {
        if (this.getSpellAmount() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.spellList.size()) {
            TraitWithCost spell = this.spellList.currentEntry();
            if (spell instanceof AbstractBasicTrait) {
                String name = ((AbstractBasicTrait)((Object)spell)).getDisplayName();
                if (name.equalsIgnoreCase(spellName)) {
                    return true;
                }
                name = ((AbstractBasicTrait)((Object)spell)).getName();
                if (name.equalsIgnoreCase(spellName)) {
                    return true;
                }
            }
            this.spellList.next();
            ++i;
        }
        return false;
    }

    public boolean tryCastCurrentSpell() {
        TraitWithCost currentSpell = this.spellList.currentEntry();
        if (currentSpell == null) {
            return false;
        }
        RacesAndClasses plugin = RacesAndClasses.getPlugin();
        List blocks = this.player.getPlayer().getLineOfSight(new HashSet(), 100);
        Block lookingAt = (Block)blocks.iterator().next();
        ItemStack wandItem = new ItemStack(plugin.getConfigManager().getGeneralConfig().getConfig_itemForMagic().generateItem());
        plugin.fireEventIntern((Event)new PlayerInteractEvent(this.player.getPlayer(), Action.LEFT_CLICK_AIR, wandItem, lookingAt, BlockFace.UP));
        return true;
    }

    public boolean isWandItem(ItemStack item) {
        RaceContainer raceHolder;
        if (this.player == null) {
            return false;
        }
        if (item == null) {
            return false;
        }
        RacesAndClasses plugin = RacesAndClasses.getPlugin();
        HashSet<WandItem> wands = new HashSet<WandItem>();
        wands.add(plugin.getConfigManager().getGeneralConfig().getConfig_itemForMagic());
        ClassContainer classHolder = this.player.getclass();
        if (classHolder != null) {
            wands.addAll(classHolder.getAdditionalWandMaterials());
        }
        if ((raceHolder = this.player.getRace()) != null) {
            wands.addAll(raceHolder.getAdditionalWandMaterials());
        }
        for (WandItem wand : wands) {
            if (!wand.isItem(item)) continue;
            return true;
        }
        return false;
    }
}

