/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.skilltree;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.SkillTreeTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PlayerSkillTreeManager {
    private final Map<Trait, Integer> presentTraits = new HashMap<Trait, Integer>();
    private final RaCPlayer player;
    private final PlayerSavingData data;

    public PlayerSkillTreeManager(RaCPlayer player, PlayerSavingData data) {
        this.player = player;
        this.data = data;
    }

    public int getLevel(Trait trait) {
        return this.presentTraits.containsKey(trait) ? this.presentTraits.get(trait) : 0;
    }

    public void removeTrait(Trait trait) {
        this.presentTraits.remove(trait);
        if (trait instanceof SkillTreeTrait) {
            trait.skillLevelChanged(this.player);
        }
        this.save();
    }

    public void setTraitLevel(Trait trait, int level) {
        this.presentTraits.put(trait, level);
        if (trait instanceof SkillTreeTrait) {
            trait.skillLevelChanged(this.player);
        }
        this.save();
    }

    private void save() {
        HashMap<String, Integer> skillTree = new HashMap<String, Integer>();
        for (Map.Entry<Trait, Integer> entry : this.presentTraits.entrySet()) {
            String name = entry.getKey().getDisplayName();
            int level = entry.getValue();
            if (level <= 0) continue;
            skillTree.put(name, level);
        }
        this.data.overrideSkilltree(skillTree);
    }

    public Map<Trait, Integer> getTraitsWithLevels() {
        return new HashMap<Trait, Integer>(this.presentTraits);
    }

    public int getFreeSkillpoints() {
        int level = this.player.getLevelManager().getCurrentLevel();
        int every = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_skillpointEveryXLevel();
        int free = level / every;
        for (Map.Entry<Trait, Integer> entry : this.presentTraits.entrySet()) {
            int i = 1;
            while (i <= entry.getValue()) {
                free -= entry.getKey().getSkillPointCost(i);
                ++i;
            }
        }
        return Math.max(0, free);
    }

    public PlayerSkillTreeManager reloadFromData() {
        this.presentTraits.clear();
        Set<Trait> traits = TraitHolderCombinder.getAllTraitsOfPlayer(this.player);
        Map<String, Integer> skillTree = this.data.getSkillTree();
        block0: for (Map.Entry<String, Integer> entry : skillTree.entrySet()) {
            String name = entry.getKey();
            int level = entry.getValue();
            for (Trait trait : traits) {
                if (!name.equalsIgnoreCase(trait.getDisplayName())) continue;
                this.setTraitLevel(trait, level);
                continue block0;
            }
        }
        return this;
    }

    public void clearSkills() {
        this.presentTraits.clear();
        this.data.clearSkilltree();
    }

    public void replaceWithNew(Map<Trait, Integer> toApply) {
        this.presentTraits.clear();
        if (toApply != null && !toApply.isEmpty()) {
            this.presentTraits.putAll(toApply);
        }
        this.save();
    }
}

