/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard;

import de.tobiyas.racesandclasses.APIs.CooldownApi;
import de.tobiyas.racesandclasses.APIs.GroupAPI;
import de.tobiyas.racesandclasses.datacontainer.arrow.ArrowManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard.PlayerRaCScoreboardManager;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.PlayerSpellManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.MagicSpellTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithRestrictions;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.util.RaC.math.Math2;
import java.util.HashSet;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class ScoreboardUpdater {
    private final RaCPlayer player;
    private final PlayerRaCScoreboardManager manager;

    public ScoreboardUpdater(RaCPlayer player, PlayerRaCScoreboardManager manager) {
        this.player = player;
        this.manager = manager;
    }

    public void updateCooldown() {
        List<Trait> traits = this.player.getTraits();
        String playerName = this.player.getName();
        this.manager.clearCategory(PlayerRaCScoreboardManager.SBCategory.Cooldown);
        boolean hasAddedAny = false;
        for (Trait trait : traits) {
            boolean supportsCooldown;
            if (!(trait instanceof TraitWithRestrictions)) continue;
            TraitWithRestrictions twr = (TraitWithRestrictions)trait;
            boolean bl = supportsCooldown = twr.getMaxUplinkTime() > 0;
            if (!supportsCooldown) continue;
            int cooldown = CooldownApi.getCooldownOfPlayer(playerName, twr.getCooldownName());
            if (cooldown < 0) {
                cooldown = 0;
            }
            this.manager.setValue(PlayerRaCScoreboardManager.SBCategory.Cooldown, twr.getDisplayName(), cooldown);
            hasAddedAny = true;
        }
        if (!hasAddedAny) {
            this.manager.setValue(PlayerRaCScoreboardManager.SBCategory.Cooldown, ChatColor.RED + "No Cooldowns", 1);
        }
        this.manager.update();
    }

    public void updateSpells() {
        PlayerSpellManager spellManager = this.player.getSpellManager();
        MagicSpellTrait currentSpell = spellManager.getCurrentSpell();
        this.manager.clearCategory(PlayerRaCScoreboardManager.SBCategory.Spells);
        boolean hasAddedAny = false;
        if (currentSpell != null) {
            int id = spellManager.getSpellAmount();
            for (MagicSpellTrait spell : spellManager.getAllSpells()) {
                boolean selected = spell == currentSpell;
                ChatColor pre = selected ? ChatColor.RED : ChatColor.YELLOW;
                ChatColor after = selected ? ChatColor.AQUA : ChatColor.BLUE;
                String name = this.getFromCooldown(spell, pre, after);
                this.manager.setValue(PlayerRaCScoreboardManager.SBCategory.Spells, name, id);
                --id;
                hasAddedAny = true;
            }
        }
        if (!hasAddedAny) {
            this.manager.setValue(PlayerRaCScoreboardManager.SBCategory.Spells, ChatColor.RED + "No Spells", 1);
        }
        this.manager.update();
    }

    public void updateArrows() {
        ArrowManager arrowManager = this.player.getArrowManager();
        this.manager.clearCategory(PlayerRaCScoreboardManager.SBCategory.Arrows);
        boolean hasAddedAny = false;
        if (arrowManager.hasAnyArrow()) {
            AbstractArrow currentArrow = arrowManager.getCurrentArrow();
            int id = arrowManager.getNumberOfArrowTypes();
            for (AbstractArrow arrow : arrowManager.getAllArrows()) {
                boolean selected = arrow == currentArrow;
                ChatColor pre = selected ? ChatColor.RED : ChatColor.YELLOW;
                ChatColor after = selected ? ChatColor.AQUA : ChatColor.BLUE;
                String name = this.getFromCooldown(arrow, pre, after);
                this.manager.setValue(PlayerRaCScoreboardManager.SBCategory.Arrows, name, id);
                --id;
                hasAddedAny = true;
            }
        }
        if (!hasAddedAny) {
            this.manager.setValue(PlayerRaCScoreboardManager.SBCategory.Arrows, ChatColor.RED + "No Arrows", 1);
        }
        this.manager.update();
    }

    private String getFromCooldown(TraitWithRestrictions trait, ChatColor pre, ChatColor after) {
        String name = trait.getDisplayName();
        double cooldown = CooldownApi.getCooldownOfPlayer(this.player.getName(), trait.getCooldownName());
        if (cooldown <= 0.0) {
            return pre + name;
        }
        double percent = cooldown / (double)trait.getMaxUplinkTime();
        percent = Math2.clamp(0.0, percent, 1.0);
        return this.colorizeToPercent(name, percent, pre, after);
    }

    private String colorizeToPercent(String toColorize, double percent, ChatColor front, ChatColor back) {
        int max = toColorize.length();
        int chars = (int)(percent * (double)max);
        chars = Math2.clamp(0, chars, max);
        String first = toColorize.substring(0, chars);
        String second = toColorize.substring(chars, max);
        return front + first + back + second;
    }

    public void updateGeneral() {
        int health = (int)this.player.getHealth();
        int mana = (int)this.player.getManaManager().getCurrentMana();
        int level = this.player.getLevelManager().getCurrentLevel();
        int exp = this.player.getLevelManager().getCurrentExpOfLevel();
        this.manager.setValue(PlayerRaCScoreboardManager.SBCategory.General, ChatColor.RED + "Health", health);
        this.manager.setValue(PlayerRaCScoreboardManager.SBCategory.General, ChatColor.BLUE + "Mana", mana);
        this.manager.setValue(PlayerRaCScoreboardManager.SBCategory.General, ChatColor.YELLOW + "Level", level);
        this.manager.setValue(PlayerRaCScoreboardManager.SBCategory.General, ChatColor.YELLOW + "Exp", exp);
    }

    public void updateGroup() {
        HashSet<Player> toShow = new HashSet<Player>(GroupAPI.getMembersOfGroup(this.player.getPlayer()));
        toShow.add(this.player.getPlayer());
        this.manager.clearCategory(PlayerRaCScoreboardManager.SBCategory.Group);
        for (Player player : toShow) {
            this.manager.setValue(PlayerRaCScoreboardManager.SBCategory.Group, this.generateColorTextFromPlayer(player), (int)player.getHealth());
        }
    }

    private String generateColorTextFromPlayer(Player player) {
        double percent = player.getHealth() / player.getMaxHealth();
        return this.colorizeToPercent(player.getDisplayName(), percent, ChatColor.GREEN, ChatColor.RED);
    }
}

