/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard.DisplayTimer;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard.ScoreboardUpdater;
import de.tobiyas.util.RaC.vollotile.VollotileCode;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

public class PlayerRaCScoreboardManager {
    private final Map<SBCategory, Map<String, Integer>> toShow = new EnumMap<SBCategory, Map<String, Integer>>(SBCategory.class);
    private final RaCPlayer player;
    private SBCategory selectedCategory = SBCategory.General;
    private boolean needsUpdate = true;
    private final ScoreboardUpdater updater;
    private final DisplayTimer displayTimer;

    public PlayerRaCScoreboardManager(RaCPlayer player) {
        this.player = player;
        this.updater = new ScoreboardUpdater(player, this);
        this.displayTimer = new DisplayTimer();
        SBCategory[] sBCategoryArray = SBCategory.values();
        int n = sBCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            SBCategory category = sBCategoryArray[n2];
            this.toShow.put(category, new HashMap());
            ++n2;
        }
    }

    public void setValue(SBCategory category, String key, int value) {
        if (category == null || key == null || key.isEmpty()) {
            return;
        }
        if (category == SBCategory.Cooldown && value <= 0) {
            this.remove(category, key);
            return;
        }
        Map<String, Integer> map = this.toShow.get((Object)category);
        Integer old = map.put(key, value);
        if (old != null && old.equals(value)) {
            return;
        }
        this.needsUpdate = true;
    }

    public String getKeyForValue(SBCategory category, int value) {
        if (category == null) {
            return "";
        }
        Map<String, Integer> map = this.toShow.get((Object)category);
        if (map == null) {
            return "";
        }
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return "";
    }

    public void clearCategory(SBCategory category) {
        Map<String, Integer> map = this.toShow.get((Object)category);
        if (map.isEmpty()) {
            return;
        }
        map.clear();
        this.needsUpdate = true;
    }

    public void remove(SBCategory category, String key) {
        if (category == null || key == null || key.isEmpty()) {
            return;
        }
        Map<String, Integer> map = this.toShow.get((Object)category);
        if (!map.containsKey(key)) {
            return;
        }
        map.remove(key);
        this.needsUpdate = true;
    }

    public void update() {
        boolean removeScoreboard = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().isConfig_disableAllScoreboardOutputs();
        if (removeScoreboard) {
            return;
        }
        if (!this.needsUpdate) {
            return;
        }
        Scoreboard board = this.player.getScoreboard();
        if (board == null) {
            return;
        }
        for (String entry : board.getEntries()) {
            board.resetScores(entry);
        }
        String sbPre = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_gui_scoreboard_name();
        sbPre = ChatColor.translateAlternateColorCodes((char)'&', (String)sbPre);
        SBCategory[] sBCategoryArray = SBCategory.values();
        int n = sBCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            SBCategory category = sBCategoryArray[n2];
            Objective objective = board.getObjective(category.name());
            if (objective == null) {
                objective = board.registerNewObjective(category.name(), "dummy");
                objective.setDisplayName(String.valueOf(sbPre) + " " + category.getHeadline());
            }
            Map<String, Integer> map = this.toShow.get((Object)category);
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                String key = entry.getKey();
                int value = entry.getValue();
                Score score = objective.getScore(this.shortenKey(key));
                score.setScore(value);
            }
            ++n2;
        }
        this.needsUpdate = false;
    }

    private String shortenKey(String key) {
        VollotileCode.MCVersion version = VollotileCodeManager.getVollotileCode().getVersion();
        if (key.length() > 16 && !version.isVersionGreaterOrEqual(VollotileCode.MCVersion.v1_8_R1)) {
            key = key.substring(0, 16);
        }
        if (key.length() > 40 && version.isVersionGreaterOrEqual(VollotileCode.MCVersion.v1_8_R1)) {
            key = key.substring(0, 39);
        }
        return key;
    }

    public void show() {
        boolean removeScoreboard = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().isConfig_disableAllScoreboardOutputs();
        if (removeScoreboard) {
            return;
        }
        if (!this.player.isOnline()) {
            return;
        }
        if (this.displayTimer.shouldBeHidden() || this.toShow.get((Object)this.selectedCategory).size() == 0) {
            this.hide();
            return;
        }
        Scoreboard board = this.player.getScoreboard();
        Objective obj = board.getObjective(this.selectedCategory.name());
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
    }

    public void hide() {
        boolean removeScoreboard = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().isConfig_disableAllScoreboardOutputs();
        if (removeScoreboard) {
            return;
        }
        if (!this.player.isOnline()) {
            return;
        }
        Scoreboard board = this.player.getScoreboard();
        Objective obj = board.getObjective("empty");
        if (obj == null) {
            obj = board.registerNewObjective("empty", "dummy");
        }
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
    }

    public SBCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    public void setSelectedCategory(SBCategory selectedCategory) {
        if (selectedCategory == null || this.selectedCategory == selectedCategory) {
            return;
        }
        this.selectedCategory = selectedCategory;
    }

    public void updateSelectAndShow(SBCategory category, long showTime) {
        if (category == null) {
            return;
        }
        switch (category) {
            case Arrows: {
                this.updater.updateArrows();
                break;
            }
            case Cooldown: {
                this.updater.updateCooldown();
                break;
            }
            case Spells: {
                this.updater.updateSpells();
                break;
            }
            case General: {
                this.updater.updateGeneral();
                break;
            }
            case Group: {
                this.updater.updateGroup();
                break;
            }
            default: {
                return;
            }
        }
        this.refreshDisplayTime(showTime);
        this.setSelectedCategory(category);
        this.update();
        this.show();
    }

    public void updateSelectAndShow(SBCategory category) {
        this.updateSelectAndShow(category, Long.MAX_VALUE);
    }

    public void refreshDisplayTime(long time) {
        boolean removeScoreboard = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().isConfig_disableAllScoreboardOutputs();
        if (removeScoreboard) {
            return;
        }
        boolean inf = time >= Long.MAX_VALUE;
        this.displayTimer.setAlwaysShow(inf);
        this.displayTimer.addHideDelay(time);
    }

    public void tick() {
        boolean removeScoreboard = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().isConfig_disableAllScoreboardOutputs();
        if (removeScoreboard) {
            return;
        }
        if (this.displayTimer.shouldBeHidden()) {
            this.hide();
        }
    }

    public void cycleToNext() {
        SBCategory nextCategory = this.selectedCategory.getNextCategory();
        this.updateSelectAndShow(nextCategory);
    }

    public ScoreboardUpdater getUpdater() {
        return this.updater;
    }

    public static enum SBCategory {
        Cooldown(ChatColor.RED + "Cooldowns:"),
        Spells(ChatColor.GREEN + "Spells:"),
        Arrows(ChatColor.AQUA + "Arrows:"),
        General(ChatColor.YELLOW + "General:"),
        Group(ChatColor.DARK_BLUE + "Group:");

        private final String headline;

        private SBCategory(String headline) {
            this.headline = headline;
        }

        public String getHeadline() {
            return this.headline;
        }

        public SBCategory getNextCategory() {
            switch (this) {
                case Cooldown: {
                    return Spells;
                }
                case Spells: {
                    return Arrows;
                }
                case Arrows: {
                    return General;
                }
                case General: {
                    return Group;
                }
                case Group: {
                    return Cooldown;
                }
            }
            return General;
        }
    }
}

