/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.playerdisplay;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.DisplaySegment;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import de.tobiyas.util.RaC.vollotile.helper.PermanentActionBarMessages;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerActionBarDisplay {
    private final RaCPlayer player;
    private final PermanentActionBarMessages messages;
    private final boolean supportsActionBars;
    private Set<DisplaySegment> segments = new HashSet<DisplaySegment>();

    public PlayerActionBarDisplay(RaCPlayer player) {
        this.player = player;
        this.messages = PermanentActionBarMessages.get((Plugin)RacesAndClasses.getPlugin());
        this.supportsActionBars = VollotileCodeManager.getVollotileCode().getVersion().hasActionBar();
    }

    public void display() {
        if (!this.supportsActionBars) {
            return;
        }
        if (!this.player.isOnline()) {
            return;
        }
        Player player = this.player.getPlayer();
        String line = this.generateLine();
        if (line.isEmpty()) {
            this.messages.removeMessage(player);
        } else {
            this.messages.setMessage(player, line);
        }
    }

    private String generateLine() {
        String format = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_actionbar_format();
        if (format.isEmpty()) {
            return "";
        }
        for (DisplaySegment segment : this.segments) {
            format = format.replace("%" + segment.getName() + "%", segment.getDisplayString()).replace("%" + segment.getName().toUpperCase() + "%", segment.getDisplayString());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)format);
    }

    public void setSegment(String key, String displayString) {
        for (DisplaySegment segment : this.segments) {
            if (!segment.getName().equals(key)) continue;
            segment.setDisplayString(displayString);
            return;
        }
        DisplaySegment newSegment = new DisplaySegment(key, displayString);
        this.segments.add(newSegment);
    }
}

