/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.player;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class RaCPlayerManager {
    private final Set<RaCPlayer> playerSet = new HashSet<RaCPlayer>();
    private YAMLConfigExtended cacheConfig;
    private static RaCPlayerManager instance;

    protected RaCPlayerManager() {
        if (this.hasUUIDSupport()) {
            return;
        }
        File cacheFolder = new File(RacesAndClasses.getPlugin().getDataFolder(), "cache");
        if (!cacheFolder.exists()) {
            cacheFolder.mkdirs();
        }
        File cacheFile = new File(cacheFolder, "uuid_cache.yml");
        this.cacheConfig = new YAMLConfigExtended(cacheFile).load();
        for (String key : this.cacheConfig.getRootChildren()) {
            try {
                UUID id = UUID.fromString(key);
                String name = this.cacheConfig.getString(key);
                this.playerSet.add(new RaCPlayer(id, name));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public RaCPlayer getPlayer(Player player) {
        if (player == null) {
            return null;
        }
        if (player instanceof RaCPlayer) {
            return (RaCPlayer)player;
        }
        if (this.hasUUIDSupport()) {
            UUID id = player.getUniqueId();
            for (RaCPlayer racPlayer : this.playerSet) {
                if (!racPlayer.getUniqueId().equals(id)) continue;
                return racPlayer;
            }
            RaCPlayer neu = this.createNew(player);
            this.playerSet.add(neu);
            return neu;
        }
        String name = player.getName();
        for (RaCPlayer racPlayer : this.playerSet) {
            if (!racPlayer.getName().equals(name)) continue;
            return racPlayer;
        }
        RaCPlayer neu = this.createNew(player);
        this.playerSet.add(neu);
        return neu;
    }

    public RaCPlayer getPlayerByName(String playerName) {
        if (playerName == null) {
            return null;
        }
        Player player = PlayerUtils.getPlayer(playerName);
        if (player != null) {
            return this.getPlayer(player);
        }
        for (RaCPlayer racPlayer : this.playerSet) {
            if (!racPlayer.getName().equals(playerName)) continue;
            return racPlayer;
        }
        return null;
    }

    public RaCPlayer getPlayer(UUID playerUuid) {
        if (playerUuid == null) {
            return null;
        }
        for (RaCPlayer racPlayer : this.playerSet) {
            if (!racPlayer.getUniqueId().equals(playerUuid)) continue;
            return racPlayer;
        }
        if (!this.hasUUIDSupport()) {
            return null;
        }
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null) {
            return null;
        }
        RaCPlayer neu = this.createNew(player);
        this.playerSet.add(neu);
        return neu;
    }

    private RaCPlayer createNew(Player player) {
        if (player == null) {
            return null;
        }
        if (this.hasUUIDSupport()) {
            return new RaCPlayer(player.getUniqueId(), player.getName());
        }
        UUID newID = UUID.randomUUID();
        String playerName = player.getName();
        this.cacheConfig.set(newID.toString(), playerName);
        this.cacheConfig.saveAsync();
        return new RaCPlayer(newID, playerName);
    }

    private boolean hasUUIDSupport() {
        try {
            Bukkit.getPlayer((UUID)UUID.randomUUID());
            return true;
        }
        catch (Throwable exp) {
            return false;
        }
    }

    public Collection<RaCPlayer> getOnlinePlayers() {
        HashSet<RaCPlayer> online = new HashSet<RaCPlayer>();
        for (Player pl : PlayerUtils.getOnlinePlayers()) {
            RaCPlayer racPlayer = this.getPlayer(pl);
            if (racPlayer == null) continue;
            online.add(racPlayer);
        }
        return online;
    }

    public static RaCPlayerManager get() {
        if (instance == null) {
            instance = new RaCPlayerManager();
        }
        return instance;
    }
}

