/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.player;

import de.tobiyas.racesandclasses.APIs.InFightAPI;
import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.armorandtool.ArmorToolManager;
import de.tobiyas.racesandclasses.datacontainer.arrow.ArrowManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.hotkeys.HotKeyInventory;
import de.tobiyas.racesandclasses.pets.PlayerPetManager;
import de.tobiyas.racesandclasses.playermanagement.health.HealthManager;
import de.tobiyas.racesandclasses.playermanagement.leveling.PlayerLevelManager;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.PlayerActionBarDisplay;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard.PlayerRaCScoreboardManager;
import de.tobiyas.racesandclasses.playermanagement.skilltree.PlayerSkillTreeManager;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.PlayerSpellManager;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.mana.ManaManager;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.racesandclasses.saving.PlayerSavingManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.StaticTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithRestrictions;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;

public class RaCPlayer {
    private final UUID playerUUID;
    private final String playerName;
    private final RacesAndClasses plugin;

    public RaCPlayer(UUID playerUUID, String playerName) {
        this.playerUUID = playerUUID;
        this.playerName = playerName;
        this.plugin = RacesAndClasses.getPlugin();
    }

    public String getName() {
        return this.playerName;
    }

    public String getDisplayName() {
        return this.getPlayer().getDisplayName();
    }

    public RaceContainer getRace() {
        return (RaceContainer)this.plugin.getRaceManager().getHolderOfPlayer(this);
    }

    public ClassContainer getclass() {
        return (ClassContainer)this.plugin.getClassManager().getHolderOfPlayer(this);
    }

    public PlayerSavingData getPlayerSaveData() {
        return PlayerSavingManager.get().getPlayerData(this.playerUUID);
    }

    public boolean setClass(ClassContainer container) {
        return this.plugin.getClassManager().addPlayerToHolder(this, container.getDisplayName(), true);
    }

    public boolean setRace(RaceContainer container) {
        return this.plugin.getRaceManager().addPlayerToHolder(this, container.getDisplayName(), true);
    }

    public Player getRealPlayer() {
        if (!this.hasUUIDSupport()) {
            return PlayerUtils.getPlayer(this.playerName);
        }
        return Bukkit.getPlayer((UUID)this.playerUUID);
    }

    public OfflinePlayer getOfflinePlayer() {
        if (!this.hasUUIDSupport()) {
            return PlayerUtils.getPlayer(this.playerName);
        }
        return Bukkit.getOfflinePlayer((UUID)this.playerUUID);
    }

    public boolean isOnline() {
        Player player = this.getPlayer();
        return player != null && player.isOnline();
    }

    public String getCurrentChatChannel() {
        return this.plugin.getChannelManager().getCurrentChannel(this);
    }

    public void setCurrentChatChannel(String newChannel) {
        this.plugin.getChannelManager().changeCurrentChannel(this, newChannel);
    }

    public Player getPlayer() {
        return PlayerUtils.getPlayer(this.playerUUID);
    }

    public ManaManager getManaManager() {
        return this.plugin.getPlayerManager().getContainer(this).getSpellManager().getManaManager();
    }

    public PlayerSpellManager getSpellManager() {
        return this.plugin.getPlayerManager().getContainer(this).getSpellManager();
    }

    public PlayerActionBarDisplay getActionbarDisplay() {
        return this.plugin.getPlayerManager().getContainer(this).getActionbarDisplay();
    }

    public ArmorToolManager getArmorManager() {
        return this.plugin.getPlayerManager().getContainer(this).getArmorToolManager();
    }

    public ArrowManager getArrowManager() {
        return this.plugin.getPlayerManager().getContainer(this).getArrowManager();
    }

    public PlayerLevelManager getLevelManager() {
        return this.plugin.getPlayerManager().getContainer(this).getPlayerLevelManager();
    }

    public HealthManager getHealthManager() {
        return this.plugin.getPlayerManager().getContainer(this).getHealthManager();
    }

    public double getHealth() {
        return this.getHealthManager().getCurrentHealth();
    }

    public double getMaxHealth() {
        return this.getHealthManager().getMaxHealth();
    }

    public double getCurrentMana() {
        return this.getManaManager().getCurrentMana();
    }

    public double getMaxMana() {
        return this.getManaManager().getMaxMana();
    }

    public int getCurrentLevel() {
        return this.getLevelManager().getCurrentLevel();
    }

    public boolean displayHealth() {
        this.getHealthManager().forceHPOut();
        return true;
    }

    public PlayerRaCScoreboardManager getScoreboardManager() {
        return this.plugin.getPlayerManager().getContainer(this).getPlayerScoreboardManager();
    }

    public PlayerSkillTreeManager getSkillTreeManager() {
        return this.plugin.getPlayerManager().getContainer(this).getSkillTreeManager();
    }

    public List<Trait> getTraits() {
        int level = this.getLevelManager().getCurrentLevel();
        LinkedList<Trait> returnList = new LinkedList<Trait>();
        Set<Trait> traits = TraitHolderCombinder.getSkillTreeReducedTraitsOfPlayer(this);
        for (Trait trait : traits) {
            if (trait instanceof StaticTrait || !(trait instanceof TraitWithRestrictions) || !((TraitWithRestrictions)trait).isInLevelRange(level)) continue;
            returnList.add(trait);
        }
        return returnList;
    }

    public PlayerPetManager getPlayerPetManager() {
        return this.plugin.getPlayerManager().getContainer(this).getPlayerPetManager();
    }

    public UUID getUniqueId() {
        return this.playerUUID;
    }

    private boolean hasUUIDSupport() {
        try {
            Bukkit.getPlayer((UUID)UUID.randomUUID());
            return true;
        }
        catch (Throwable exp) {
            return false;
        }
    }

    public boolean hasPermission(String permission) {
        if (this.isOnline()) {
            return this.plugin.getPermissionManager().checkPermissionsSilent((CommandSender)this.getPlayer(), permission);
        }
        return this.plugin.getPermissionManager().checkPermissionsSilent(this.playerName, permission);
    }

    public void sendTranslatedMessage(String tag) {
        if (!this.isOnline()) {
            return;
        }
        LanguageAPI.sendTranslatedMessage((CommandSender)this.getPlayer(), tag);
    }

    public void sendTranslatedMessage(String tag, Map<String, String> replacements) {
        if (!this.isOnline()) {
            return;
        }
        LanguageAPI.sendTranslatedMessage((CommandSender)this.getPlayer(), tag, replacements);
    }

    public void sendTranslatedMessage(String tag, String ... replacements) {
        if (!this.isOnline()) {
            return;
        }
        LanguageAPI.sendTranslatedMessage((CommandSender)this.getPlayer(), tag, replacements);
    }

    public HotKeyInventory getHotkeyInventory() {
        return this.plugin.getHotkeyManager().getInv(this);
    }

    public boolean isInFight() {
        return InFightAPI.isInFight(this);
    }

    public void heal(double healValue) {
        CompatibilityModifier.BukkitPlayer.safeHeal(healValue, this.getPlayer());
    }

    public Scoreboard getScoreboard() {
        Player pl = this.getRealPlayer();
        return pl == null ? null : pl.getScoreboard();
    }

    public void sendMessage(String message) {
        Player pl = this.getRealPlayer();
        if (pl != null) {
            pl.sendMessage(message);
        }
    }

    public Location getLocation() {
        Player pl = this.getRealPlayer();
        return pl == null ? null : pl.getLocation();
    }

    public GameMode getGameMode() {
        Player pl = this.getRealPlayer();
        return pl == null ? GameMode.SURVIVAL : pl.getGameMode();
    }

    public World getWorld() {
        Player pl = this.getRealPlayer();
        return pl == null ? null : pl.getWorld();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.playerName == null ? 0 : this.playerName.hashCode());
        result = 31 * result + (this.playerUUID == null ? 0 : this.playerUUID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RaCPlayer other = (RaCPlayer)obj;
        if (this.playerName == null ? other.playerName != null : !this.playerName.equals(other.playerName)) {
            return false;
        }
        return !(this.playerUUID == null ? other.playerUUID != null : !this.playerUUID.equals(other.playerUUID));
    }
}

