/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.leveling.values;

import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class LevelValueModifyReader {
    private final YAMLConfigExtended config;
    private final String start;

    public LevelValueModifyReader(YAMLConfigExtended config, String start) {
        this.config = config;
        String[] split = start.split(Pattern.quote("."));
        if (split.length > 0) {
            LinkedList<String> list = new LinkedList<String>(Arrays.asList(split));
            String last = (String)list.remove(list.size() - 1);
            String parent = StringUtils.join(list, (String)".");
            for (String val : config.getChildren(parent)) {
                if (!val.equalsIgnoreCase(last)) continue;
                start = String.valueOf(parent) + "." + last;
            }
        }
        this.start = start;
    }

    public LevelModifier parse(double defaultValue) {
        if (!this.config.contains(this.start)) {
            return new LevelModifier();
        }
        LinkedList<LevelModContainer> list = new LinkedList<LevelModContainer>();
        if (!this.config.isConfigurationSection(this.start)) {
            return new LevelModifier(new LevelModContainer(this.parseToDouble(this.start, defaultValue)));
        }
        for (String key : this.config.getChildren(this.start)) {
            double value;
            LevelModContainer container = LevelModContainer.parse(key, value = this.parseToDouble(String.valueOf(this.start) + "." + key, defaultValue));
            if (container == null) continue;
            list.add(container);
        }
        return new LevelModifier(list);
    }

    private double parseToDouble(String path, double defaultValue) {
        if (!this.config.contains(path)) {
            return defaultValue;
        }
        if (this.config.isDouble(path)) {
            return this.config.getDouble(path, defaultValue);
        }
        if (this.config.isInt(path)) {
            return this.config.getInt(path, (int)defaultValue);
        }
        if (this.config.isString(path)) {
            try {
                return Double.parseDouble(this.config.getString(path, String.valueOf(defaultValue)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static class LevelModContainer {
        private final int startLevel;
        private final int endLevel;
        private final double value;

        public LevelModContainer(int startLevel, int endLevel, double value) {
            this.startLevel = startLevel;
            this.endLevel = endLevel;
            this.value = value;
        }

        public LevelModContainer(double value) {
            this.startLevel = Integer.MIN_VALUE;
            this.endLevel = Integer.MAX_VALUE;
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }

        public int getStartLevel() {
            return this.startLevel;
        }

        public int getEndLevel() {
            return this.endLevel;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static LevelModContainer parse(String toParse, double value) {
            try {
                if (toParse.contains("-")) {
                    String[] parts = toParse.split(Pattern.quote("-"));
                    if (parts.length != 2) {
                        return null;
                    }
                    int start = Integer.parseInt(parts[0]);
                    int end = Integer.parseInt(parts[1]);
                    return new LevelModContainer(start, end, value);
                }
                if (toParse.startsWith("<=")) {
                    toParse = toParse.substring(2);
                    int end = Integer.parseInt(toParse);
                    return new LevelModContainer(Integer.MIN_VALUE, end, value);
                }
                if (toParse.startsWith(">=")) {
                    toParse = toParse.substring(2);
                    int start = Integer.parseInt(toParse);
                    return new LevelModContainer(start, Integer.MAX_VALUE, value);
                }
                if (toParse.startsWith("<")) {
                    toParse = toParse.substring(1);
                    int end = Integer.parseInt(toParse);
                    return new LevelModContainer(Integer.MIN_VALUE, end - 1, value);
                }
                if (!toParse.startsWith(">")) return null;
                toParse = toParse.substring(1);
                int start = Integer.parseInt(toParse);
                return new LevelModContainer(start + 1, Integer.MAX_VALUE, value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    public static class LevelModifier {
        private static final LevelModContainer defaultContainer = new LevelModContainer(0.0);
        private final List<LevelModContainer> list;

        public LevelModifier(List<LevelModContainer> list) {
            LinkedList<LevelModContainer> linkedList = this.list = list == null ? new LinkedList<LevelModContainer>() : list;
            if (list.isEmpty()) {
                list.add(defaultContainer);
            }
        }

        public LevelModifier(LevelModContainer ... containers) {
            this(Arrays.asList(containers));
        }

        public LevelModifier() {
            this.list = new LinkedList<LevelModContainer>();
            this.list.add(defaultContainer);
        }

        public double getForLevel(int level) {
            double highest = -2.147483648E9;
            for (LevelModContainer container : this.list) {
                if (container.getEndLevel() < level || container.getStartLevel() > level) continue;
                highest = Math.max(highest, container.getValue());
            }
            return highest;
        }

        public static LevelModifier empty() {
            return LevelModifier.single(0.0);
        }

        public static LevelModifier single(double value) {
            LevelModContainer empty = new LevelModContainer(value);
            LinkedList<LevelModContainer> list = new LinkedList<LevelModContainer>();
            list.add(empty);
            return new LevelModifier(list);
        }
    }
}

