/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.leveling.manager;

import com.gmail.nossr50.api.ExperienceAPI;
import com.gmail.nossr50.api.exceptions.McMMOPlayerNotFoundException;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.leveling.manager.AbstractPlayerLevelingSystem;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.util.RaC.evaluations.EvalEvaluator;
import de.tobiyas.util.RaC.evaluations.parts.Calculation;
import de.tobiyas.util.RaC.exception.TryUtils;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class McMMOLevelManager
extends AbstractPlayerLevelingSystem {
    private final String calcString = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_mapExpPerLevelCalculationString();

    public McMMOLevelManager(RaCPlayer player, PlayerSavingData data) {
        super(player, data);
    }

    @Override
    public int getCurrentLevel() {
        if (!this.isMcMMOPresent()) {
            return 1;
        }
        return this.calcCurrentLevel();
    }

    @Override
    public int getCurrentExpOfLevel() {
        if (!this.isMcMMOPresent()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setCurrentLevel(int level) {
    }

    @Override
    public void setCurrentExpOfLevel(int currentExpOfLevel) {
    }

    @Override
    public boolean addExp(int exp) {
        return false;
    }

    @Override
    public boolean removeExp(int exp) {
        return false;
    }

    @Override
    public void checkLevelChanged() {
    }

    @Override
    public boolean canRemove(int toRemove) {
        return false;
    }

    private boolean isMcMMOPresent() {
        try {
            mcMMO mcMMO2 = this.getMCMMO();
            if (mcMMO2 == null) {
            }
            return mcMMO2.isEnabled();
        }
        finally {
            return false;
        }
    }

    private mcMMO getMCMMO() {
        try {
            return (mcMMO)Bukkit.getPluginManager().getPlugin("mcMMO");
        }
        catch (Throwable exp) {
            return null;
        }
    }

    public static boolean verifyGeneratorStringWorks(String generatorString) {
        try {
            generatorString = generatorString.toLowerCase();
            Calculation calc = EvalEvaluator.parse(generatorString);
            if (calc == null) {
                throw new IllegalArgumentException("Evaluation String not parseable");
            }
            HashMap<String, Double> vars = new HashMap<String, Double>();
            vars.put("powerlevel", 1.0);
            SkillType[] skillTypeArray = SkillType.values();
            int n = skillTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SkillType type = skillTypeArray[n2];
                vars.put(type.name(), 1.0);
                vars.put(type.getName(), 1.0);
                ++n2;
            }
            return calc.calculate(vars) != Double.NaN;
        }
        catch (Throwable exp) {
            return false;
        }
    }

    private int calcCurrentLevel() {
        Calculation calc = EvalEvaluator.parse(this.calcString);
        if (calc == null) {
            return 0;
        }
        try {
            final Player pl = this.getPlayer().getPlayer();
            int powerLevel = ExperienceAPI.getPowerLevel((Player)pl);
            HashMap<String, Double> vars = new HashMap<String, Double>();
            vars.put("powerlevel".toLowerCase(), Double.valueOf(powerLevel));
            SkillType[] skillTypeArray = SkillType.values();
            int n = skillTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                final SkillType type = skillTypeArray[n2];
                double skillLevel = TryUtils.Try(new TryUtils.Function<Double>(){

                    @Override
                    public Double doStuff() {
                        return ExperienceAPI.getLevel((Player)pl, (String)type.name());
                    }
                }, 0.0);
                vars.put(type.name().toLowerCase(), skillLevel);
                vars.put(type.getName().toLowerCase(), skillLevel);
                ++n2;
            }
            return (int)calc.calculate(vars);
        }
        catch (McMMOPlayerNotFoundException exp) {
            return 1;
        }
        catch (Throwable exp) {
            this.plugin.logStackTrace("Error while reading McMMO Level. See Error Log!", exp);
            return 1;
        }
    }

    @Override
    public void addLevel(int value) {
    }

    @Override
    public void removeLevel(int value) {
    }

    @Override
    public int getMaxEXPToNextLevel() {
        return 1;
    }
}

