/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.leveling.manager;

import de.tobiyas.racesandclasses.eventprocessing.events.leveling.PlayerLostEXPEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.leveling.PlayerReceiveEXPEvent;
import de.tobiyas.racesandclasses.playermanagement.leveling.manager.AbstractPlayerLevelingSystem;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class MCPlayerLevelManager
extends AbstractPlayerLevelingSystem {
    public MCPlayerLevelManager(RaCPlayer player, PlayerSavingData data) {
        super(player, data);
    }

    @Override
    public int getCurrentLevel() {
        return this.getRealPlayer().getLevel();
    }

    @Override
    public int getCurrentExpOfLevel() {
        return (int)(this.getRealPlayer().getExp() * (float)this.getRealPlayer().getExpToLevel());
    }

    @Override
    public void setCurrentLevel(int level) {
        this.getRealPlayer().setLevel(level);
    }

    @Override
    public void setCurrentExpOfLevel(int currentExpOfLevel) {
        this.getRealPlayer().setExp((float)(currentExpOfLevel / this.getRealPlayer().getExpToLevel()));
    }

    @Override
    public boolean addExp(int exp) {
        PlayerReceiveEXPEvent expEvent = new PlayerReceiveEXPEvent(this.player, exp);
        Bukkit.getPluginManager().callEvent((Event)expEvent);
        if (expEvent.isCancelled()) {
            return false;
        }
        exp = expEvent.getExp();
        if (exp < 1) {
            return false;
        }
        this.getRealPlayer().giveExp(exp);
        return true;
    }

    @Override
    public boolean removeExp(int exp) {
        PlayerLostEXPEvent expEvent = new PlayerLostEXPEvent(this.player, exp);
        Bukkit.getPluginManager().callEvent((Event)expEvent);
        if (expEvent.isCancelled()) {
            return false;
        }
        exp = expEvent.getExp();
        if (exp < 1) {
            return false;
        }
        int totalExp = this.getRealPlayer().getTotalExperience();
        int newTotalExp = totalExp - exp;
        if (newTotalExp < 0) {
            newTotalExp = 0;
        }
        this.getRealPlayer().setTotalExperience(newTotalExp);
        return true;
    }

    @Override
    public void checkLevelChanged() {
    }

    private Player getRealPlayer() {
        return this.player.getPlayer();
    }

    @Override
    public boolean canRemove(int toRemove) {
        return (toRemove -= this.getCurrentExpOfLevel()) > 0;
    }

    @Override
    public void addLevel(int value) {
        this.getRealPlayer().giveExpLevels(value);
    }

    @Override
    public void removeLevel(int value) {
        int newLevel = Math.max(0, this.getCurrentLevel() - value);
        this.setCurrentLevel(newLevel);
    }

    @Override
    public int getMaxEXPToNextLevel() {
        Player pl = this.player.getPlayer();
        return (int)((double)pl.getExpToLevel() * (1.0 / (1.0 - (double)pl.getExp())));
    }
}

