/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.leveling.manager;

import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.leveling.LevelingSystem;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import java.util.Map;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;

public class CustomPlayerLevelManagerEXPListener
implements Listener {
    private static CustomPlayerLevelManagerEXPListener instance;
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public CustomPlayerLevelManagerEXPListener() {
        this.plugin.registerEvents(this);
    }

    @EventHandler
    public void monsterDeadEvent(EntityDeathEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().getConfig_useLevelSystem() != LevelingSystem.RacesAndClasses) {
            return;
        }
        if (event.getEntity() == null) {
            return;
        }
        Player killer = event.getEntity().getKiller();
        if (killer == null) {
            return;
        }
        EntityType killed = event.getEntityType();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(killer);
        this.killedEntity(racPlayer, killed);
    }

    private void killedEntity(RaCPlayer racPlayer, EntityType killed) {
        Map<EntityType, Integer> expMap = this.plugin.getConfigManager().getGeneralConfig().getConfig_custom_level_exp_gain();
        if (!expMap.containsKey(killed)) {
            return;
        }
        int exp = expMap.get(killed);
        LevelAPI.addExp(racPlayer, exp);
    }

    public static void launch() {
        if (instance != null) {
            HandlerList.unregisterAll((Listener)instance);
        }
        instance = new CustomPlayerLevelManagerEXPListener();
    }
}

