/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.leveling.manager;

import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.events.leveling.LevelDownEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.leveling.LevelUpEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.leveling.PlayerLostEXPEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.leveling.PlayerReceiveEXPEvent;
import de.tobiyas.racesandclasses.playermanagement.leveling.LevelCalculator;
import de.tobiyas.racesandclasses.playermanagement.leveling.LevelPackage;
import de.tobiyas.racesandclasses.playermanagement.leveling.manager.AbstractPlayerLevelingSystem;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CustomPlayerLevelManager
extends AbstractPlayerLevelingSystem {
    public static final String CURRENT_PLAYER_LEVEL_PATH = ".level.currentLevel";
    public static final String CURRENT_PLAYER_LEVEL_EXP_PATH = ".level.currentLevelEXP";
    private int currentLevel;
    private int currentExpOfLevel;

    public CustomPlayerLevelManager(RaCPlayer player, PlayerSavingData data) {
        super(player, data);
        this.currentLevel = data.getLevel();
        this.currentExpOfLevel = data.getLevelExp();
    }

    @Override
    public int getCurrentExpOfLevel() {
        return this.currentExpOfLevel;
    }

    @Override
    public int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public RaCPlayer getPlayer() {
        return this.player;
    }

    @Override
    public int getMaxEXPToNextLevel() {
        return LevelCalculator.calculateLevelPackage(this.currentLevel).getMaxEXP();
    }

    @Override
    public void setCurrentLevel(int level) {
        int maxLvl = LevelAPI.getMaxLevel();
        if (maxLvl > 0) {
            level = Math.min(maxLvl, level);
        }
        int oldLevel = this.currentLevel;
        this.currentLevel = level;
        this.data.setLevelAndExp(this.currentLevel, this.currentExpOfLevel);
        this.checkLevelChanged();
        if (oldLevel != this.currentLevel) {
            RacesAndClasses.getPlugin().fireEventToBukkit((Event)(oldLevel < this.currentExpOfLevel ? new LevelUpEvent(this.player, oldLevel, this.currentLevel) : new LevelDownEvent(this.player, oldLevel, level)));
        }
    }

    @Override
    public void setCurrentExpOfLevel(int currentExpOfLevel) {
        this.currentExpOfLevel = currentExpOfLevel;
        this.data.setLevelAndExp(this.currentLevel, this.currentExpOfLevel);
        this.checkLevelChanged();
    }

    @Override
    public void checkLevelChanged() {
        this.addExpIntern(0);
        this.removeExpIntern(0);
    }

    @Override
    public boolean addExp(int exp) {
        int maxLvl = LevelAPI.getMaxLevel();
        if (maxLvl > 0 && this.getCurrentLevel() >= maxLvl) {
            return false;
        }
        PlayerReceiveEXPEvent expEvent = new PlayerReceiveEXPEvent(this.player, exp);
        Bukkit.getPluginManager().callEvent((Event)expEvent);
        if (expEvent.isCancelled()) {
            return false;
        }
        exp = expEvent.getExp();
        if (exp < 1) {
            return false;
        }
        return this.addExpIntern(exp);
    }

    protected boolean addExpIntern(int exp) {
        this.currentExpOfLevel += exp;
        LevelPackage levelPack = LevelCalculator.calculateLevelPackage(this.currentLevel);
        int maxLvl = LevelAPI.getMaxLevel();
        while (this.currentExpOfLevel >= levelPack.getMaxEXP()) {
            if (maxLvl > 0 && this.getCurrentLevel() >= maxLvl) {
                this.currentExpOfLevel = 0;
                break;
            }
            ++this.currentLevel;
            this.currentExpOfLevel -= levelPack.getMaxEXP();
            Bukkit.getPluginManager().callEvent((Event)new LevelUpEvent(this.player, this.currentLevel - 1, this.currentLevel));
            levelPack = LevelCalculator.calculateLevelPackage(this.currentLevel);
        }
        this.tick();
        this.data.setLevelAndExp(this.currentLevel, this.currentExpOfLevel);
        return true;
    }

    @Override
    public boolean removeExp(int exp) {
        PlayerLostEXPEvent expEvent = new PlayerLostEXPEvent(this.player, exp);
        Bukkit.getPluginManager().callEvent((Event)expEvent);
        if (expEvent.isCancelled()) {
            return false;
        }
        exp = expEvent.getExp();
        if (exp < 1) {
            return false;
        }
        return this.removeExpIntern(exp);
    }

    protected boolean removeExpIntern(int exp) {
        this.currentExpOfLevel -= exp;
        LevelPackage levelPack = LevelCalculator.calculateLevelPackage(this.currentLevel - 1);
        while (this.currentExpOfLevel < 0) {
            if (this.currentLevel == 1) {
                this.currentExpOfLevel = 0;
                return true;
            }
            --this.currentLevel;
            this.currentExpOfLevel += levelPack.getMaxEXP();
            Bukkit.getPluginManager().callEvent((Event)new LevelDownEvent(this.player, this.currentLevel + 1, this.currentLevel));
            levelPack = LevelCalculator.calculateLevelPackage(this.currentLevel - 1);
        }
        this.tick();
        this.data.setLevelAndExp(this.currentLevel, this.currentExpOfLevel);
        return true;
    }

    @Override
    public boolean canRemove(int toRemove) {
        return (toRemove -= this.getCurrentExpOfLevel()) > 0;
    }

    @Override
    public void addLevel(int value) {
        if (value <= 0) {
            return;
        }
        int oldLevel = this.currentLevel;
        this.currentLevel += value;
        int maxLevel = LevelAPI.getMaxLevel();
        if (maxLevel > 0) {
            this.currentLevel = Math.min(this.currentLevel, maxLevel);
        }
        LevelUpEvent event = new LevelUpEvent(this.getPlayer(), oldLevel, this.currentLevel);
        RacesAndClasses.getPlugin().fireEventToBukkit((Event)event);
        this.checkLevelChanged();
    }

    @Override
    public void removeLevel(int value) {
        int maxEXP;
        if (value <= 0) {
            return;
        }
        int oldLevel = this.currentLevel;
        this.currentLevel -= value;
        if (this.currentLevel < 1) {
            this.currentLevel = 1;
        }
        if (this.currentExpOfLevel >= (maxEXP = this.getMaxEXPToNextLevel())) {
            this.currentExpOfLevel = maxEXP - 1;
        }
        LevelDownEvent event = new LevelDownEvent(this.getPlayer(), oldLevel, this.currentLevel);
        RacesAndClasses.getPlugin().fireEventToBukkit((Event)event);
        this.checkLevelChanged();
    }
}

