/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.leveling.manager;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.leveling.PlayerLevelManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.util.RaC.formating.StringFormatUtils;
import de.tobiyas.util.RaC.math.Math2;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public abstract class AbstractPlayerLevelingSystem
implements PlayerLevelManager {
    protected final RaCPlayer player;
    protected final RacesAndClasses plugin;
    protected final PlayerSavingData data;

    public AbstractPlayerLevelingSystem(RaCPlayer player, PlayerSavingData data) {
        this.player = player;
        this.data = data;
        this.plugin = RacesAndClasses.getPlugin();
    }

    @Override
    public RaCPlayer getPlayer() {
        return this.player;
    }

    @Override
    public void tick() {
        this.redrawMCLevelBar();
        this.updateActionbarData();
    }

    private void updateActionbarData() {
        int currentEXP = this.getCurrentExpOfLevel();
        int maxEXP = this.getMaxEXPToNextLevel();
        double percent = Math2.clamp(0.0, (double)currentEXP / (double)maxEXP, 1.0);
        String expString = StringFormatUtils.formatToPercent(percent, 10, '\u220e', ChatColor.YELLOW, ChatColor.BLACK);
        expString = ChatColor.YELLOW + "{" + expString + ChatColor.YELLOW + "}";
        this.player.getActionbarDisplay().setSegment("level", "" + this.getCurrentLevel());
        this.player.getActionbarDisplay().setSegment("maxexp", "" + this.getCurrentLevel());
        this.player.getActionbarDisplay().setSegment("exp", "" + currentEXP);
        this.player.getActionbarDisplay().setSegment("expbar", expString);
    }

    private void redrawMCLevelBar() {
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_gui_level_useMCLevelBar()) {
            return;
        }
        if (!this.player.isOnline()) {
            return;
        }
        Player realPlayer = this.player.getPlayer();
        float percent = (float)this.getCurrentExpOfLevel() / (float)this.getMaxEXPToNextLevel();
        realPlayer.setExp(percent);
        realPlayer.setLevel(this.getCurrentLevel());
    }
}

