/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.leveling;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.leveling.LevelPackage;
import de.tobiyas.util.RaC.evaluations.EvalEvaluator;
import de.tobiyas.util.RaC.evaluations.parts.Calculation;
import java.util.HashMap;

public class LevelCalculator {
    private static Calculation calc;

    public static LevelPackage calculateLevelPackage(int level) {
        if (level < 1) {
            return LevelCalculator.calculateLevelPackage(1);
        }
        return new LevelPackage(level, LevelCalculator.calcMaxExpForLevel(level));
    }

    protected static int calcMaxExpForLevel(int level) {
        try {
            if (calc == null) {
                String maxExpGeneratorString = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_mapExpPerLevelCalculationString();
                calc = EvalEvaluator.parse(maxExpGeneratorString);
            }
            HashMap<String, Double> vars = new HashMap<String, Double>();
            vars.put("level", Double.valueOf(level));
            return (int)calc.calculate(vars);
        }
        catch (Throwable exp) {
            return level * level * 1000;
        }
    }

    public static double calculatePercentageOfLevel(int level, int currentEXP) {
        LevelPackage levelPackage = LevelCalculator.calculateLevelPackage(level);
        return 100.0 * ((double)currentEXP / (double)levelPackage.getMaxEXP());
    }

    public static boolean verifyGeneratorStringWorks(String generatorString) {
        try {
            Calculation calc = EvalEvaluator.parse(generatorString);
            if (calc == null) {
            }
            return calc.calculate(new HashMap<String, Double>()) != Double.NaN;
        }
        finally {
            return false;
        }
    }
}

