/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement.health;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers.WorldResolver;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.util.RaC.formating.StringFormatUtils;
import de.tobiyas.util.RaC.math.Math2;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;

public class HealthManager {
    private final RaCPlayer player;
    protected final Map<String, Double> healthMap = new HashMap<String, Double>();

    public HealthManager(RaCPlayer player) {
        this.player = player;
    }

    public void addMaxHealthBonus(String key, double value) {
        this.healthMap.put(key, value);
        this.checkMaxHealth();
    }

    public void removeMaxHealthBonus(String key) {
        this.healthMap.remove(key);
        this.checkMaxHealth();
    }

    public double getMaxHealth() {
        double health = 20.0;
        for (Map.Entry<String, Double> entry : this.healthMap.entrySet()) {
            health += entry.getValue().doubleValue();
        }
        return health;
    }

    public double getHealthBoostByName(String name) {
        Double entry = this.healthMap.get(name);
        return entry == null ? 0.0 : entry;
    }

    public void rescanPlayer() {
        ClassContainer clazz;
        int level = this.player.getLevelManager().getCurrentLevel();
        RaceContainer race = this.player.getRace();
        if (race != null) {
            this.addMaxHealthBonus("race", race.getMaxHealthMod(level));
        }
        if ((clazz = this.player.getclass()) != null) {
            this.addMaxHealthBonus("class", clazz.getMaxHealthMod(level));
        }
    }

    public void checkMaxHealth() {
        if (RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().isConfig_disableHealthMods()) {
            return;
        }
        if (!this.player.isOnline()) {
            return;
        }
        double maxHealth = CompatibilityModifier.BukkitPlayer.safeGetMaxHealth(this.player.getPlayer());
        double realMaxHealth = this.getMaxHealth();
        boolean isOnDisabledWorld = WorldResolver.isOnDisabledWorld(this.player.getPlayer());
        boolean keepMaxHPOnDisabledWorld = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().isConfig_keep_max_hp_on_disabled_worlds();
        if (Math.abs(maxHealth - realMaxHealth) > 0.3) {
            if (isOnDisabledWorld && !keepMaxHPOnDisabledWorld) {
                return;
            }
            CompatibilityModifier.BukkitPlayer.safeSetMaxHealth(realMaxHealth, this.player.getPlayer());
        }
    }

    public void tick() {
        this.updateHPBar();
    }

    private void updateHPBar() {
        double currentHP = this.getCurrentHealth();
        double maxHP = this.getMaxHealth();
        double percent = Math2.clamp(0.0, currentHP / maxHP, 1.0);
        String healthBarString = StringFormatUtils.formatToPercent(percent, 10, '\u220e', ChatColor.RED, ChatColor.BLACK);
        healthBarString = ChatColor.RED + "{" + healthBarString + ChatColor.RED + "}";
        this.player.getActionbarDisplay().setSegment("health", "" + (int)currentHP);
        this.player.getActionbarDisplay().setSegment("maxhealth", "" + (int)maxHP);
        this.player.getActionbarDisplay().setSegment("healthbar", healthBarString);
    }

    public void forceHPOut() {
        if (this.player == null || !this.player.isOnline()) {
            return;
        }
        this.checkMaxHealth();
    }

    public double getCurrentHealth() {
        return CompatibilityModifier.BukkitPlayer.safeGetHealth(this.player.getPlayer());
    }

    public void damage(double damage) {
        CompatibilityModifier.BukkitPlayer.safeDamage(damage, this.player.getPlayer());
    }

    public void heal(double health) {
        CompatibilityModifier.BukkitPlayer.safeHeal(health, this.player.getPlayer());
    }

    public Map<String, Double> getHealthBoosts() {
        return new HashMap<String, Double>(this.healthMap);
    }
}

