/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.PlayerContainer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.HashMap;
import org.bukkit.plugin.Plugin;

public class PlayerManager {
    private HashMap<RaCPlayer, PlayerContainer> playerData = new HashMap();
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public PlayerManager() {
        new DebugBukkitRunnable("RaCPlayerDataTicker"){

            @Override
            protected void runIntern() {
                for (PlayerContainer container : PlayerManager.this.playerData.values()) {
                    try {
                        container.tick();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    public void init() {
        this.playerData.clear();
    }

    public void shutdown() {
        for (PlayerContainer container : this.playerData.values()) {
            container.shutdown();
        }
        this.playerData.clear();
    }

    public synchronized PlayerContainer getContainer(RaCPlayer player) {
        PlayerContainer container = this.playerData.get(player);
        if (container == null) {
            container = new PlayerContainer(player);
            this.playerData.put(player, container);
            container.init();
        }
        return container;
    }

    public String getPlayerNumber() {
        return String.valueOf(this.playerData.size());
    }
}

