/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.playermanagement;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.armorandtool.ArmorToolManager;
import de.tobiyas.racesandclasses.datacontainer.arrow.ArrowManager;
import de.tobiyas.racesandclasses.pets.PlayerPetManager;
import de.tobiyas.racesandclasses.playermanagement.health.HealthManager;
import de.tobiyas.racesandclasses.playermanagement.leveling.PlayerLevelManager;
import de.tobiyas.racesandclasses.playermanagement.leveling.manager.CustomPlayerLevelManager;
import de.tobiyas.racesandclasses.playermanagement.leveling.manager.HeroesLevelManager;
import de.tobiyas.racesandclasses.playermanagement.leveling.manager.MCPlayerLevelManager;
import de.tobiyas.racesandclasses.playermanagement.leveling.manager.McMMOLevelManager;
import de.tobiyas.racesandclasses.playermanagement.leveling.manager.SkillAPILevelManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.PlayerActionBarDisplay;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard.PlayerRaCScoreboardManager;
import de.tobiyas.racesandclasses.playermanagement.skilltree.PlayerSkillTreeManager;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.PlayerSpellManager;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.racesandclasses.saving.PlayerSavingManager;
import org.bukkit.ChatColor;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PlayerContainer {
    private static RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private final ArrowManager arrowManager;
    private final ArmorToolManager armorToolManager;
    private final PlayerPetManager petManager;
    private final RaCPlayer player;
    protected final HealthManager healthManager;
    private final PlayerSpellManager spellManager;
    private final PlayerLevelManager levelManager;
    private final PlayerRaCScoreboardManager playerScoreboardManager;
    private final PlayerSkillTreeManager playerSkillTreeManager;
    private final PlayerSavingData savingContainer;
    private final PlayerActionBarDisplay actionbarDisplay;

    public PlayerContainer(RaCPlayer player) {
        this.player = player;
        this.savingContainer = PlayerSavingManager.get().getPlayerData(player.getUniqueId());
        this.armorToolManager = new ArmorToolManager(player);
        this.arrowManager = new ArrowManager(player);
        this.healthManager = new HealthManager(player);
        this.playerScoreboardManager = new PlayerRaCScoreboardManager(player);
        this.petManager = new PlayerPetManager(player);
        this.playerSkillTreeManager = new PlayerSkillTreeManager(player, this.savingContainer);
        this.actionbarDisplay = new PlayerActionBarDisplay(player);
        switch (plugin.getConfigManager().getGeneralConfig().getConfig_useLevelSystem()) {
            case RacesAndClasses: {
                this.levelManager = new CustomPlayerLevelManager(player, this.savingContainer);
                break;
            }
            case VanillaMC: {
                this.levelManager = new MCPlayerLevelManager(player, this.savingContainer);
                break;
            }
            case SkillAPI: {
                this.levelManager = new SkillAPILevelManager(player, this.savingContainer);
                break;
            }
            case mcMMO: {
                this.levelManager = new McMMOLevelManager(player, this.savingContainer);
                break;
            }
            case Heroes: {
                this.levelManager = new HeroesLevelManager(player, this.savingContainer);
                break;
            }
            default: {
                this.levelManager = new CustomPlayerLevelManager(player, this.savingContainer);
            }
        }
        this.spellManager = new PlayerSpellManager(player);
    }

    public void init() {
        this.rescan();
    }

    public void rescan() {
        if (this.player == null || !this.player.isOnline()) {
            return;
        }
        this.arrowManager.rescanPlayer();
        this.armorToolManager.rescanPermission();
        this.armorToolManager.checkArmorNotValidEquiped();
        this.healthManager.rescanPlayer();
        this.spellManager.rescan();
        this.levelManager.checkLevelChanged();
        this.playerSkillTreeManager.reloadFromData();
        this.player.getPlayer().setMetadata("LEVEL", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)this.levelManager.getCurrentLevel()));
    }

    public void tick() {
        this.levelManager.tick();
        this.petManager.tick();
        this.spellManager.tick();
        this.healthManager.tick();
        this.actionbarDisplay.display();
    }

    public HealthManager getHealthManager() {
        return this.healthManager;
    }

    public void switchGod() {
        this.savingContainer.setGodMode(!this.savingContainer.isGodModeEnabled());
        if (this.player != null && this.player.isOnline()) {
            if (this.savingContainer.isGodModeEnabled()) {
                this.player.sendMessage(ChatColor.GREEN + "God mode toggled.");
            } else {
                this.player.sendMessage(ChatColor.RED + "God mode removed.");
            }
        }
    }

    public ArrowManager getArrowManager() {
        return this.arrowManager;
    }

    public ArmorToolManager getArmorToolManager() {
        return this.armorToolManager;
    }

    public boolean isGod() {
        return this.savingContainer.isGodModeEnabled();
    }

    public PlayerSavingData getSavingData() {
        return this.savingContainer;
    }

    public PlayerSpellManager getSpellManager() {
        return this.spellManager;
    }

    public PlayerRaCScoreboardManager getPlayerScoreboardManager() {
        return this.playerScoreboardManager;
    }

    public PlayerLevelManager getPlayerLevelManager() {
        return this.levelManager;
    }

    public PlayerPetManager getPlayerPetManager() {
        return this.petManager;
    }

    public PlayerActionBarDisplay getActionbarDisplay() {
        return this.actionbarDisplay;
    }

    public void shutdown() {
        this.petManager.despawnAndClear();
    }

    public PlayerSkillTreeManager getSkillTreeManager() {
        return this.playerSkillTreeManager;
    }
}

