/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.pets.target;

import de.tobiyas.racesandclasses.pets.SpawnedPet;
import de.tobiyas.racesandclasses.pets.target.Target;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.util.location.LocationOffsetUtils;
import de.tobiyas.util.RaC.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class OwnerTarget
implements Target {
    private final RaCPlayer owner;

    public OwnerTarget(RaCPlayer owner) {
        this.owner = owner;
    }

    @Override
    public boolean valid(SpawnedPet pet) {
        return true;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public Target.TargetType getType() {
        return Target.TargetType.Owner;
    }

    @Override
    public void setTarget(LivingEntity pet) {
        VollotileCodeManager.getVollotileCode().entityWalkToLocation(pet, LocationOffsetUtils.getRandomAround(this.owner.getLocation()), 1.0);
    }

    @Override
    public void showToOwner(RaCPlayer owner) {
        if (!owner.getPlayer().isValid()) {
            return;
        }
        Location target = owner.getLocation();
        VollotileCodeManager.getVollotileCode().sendParticleEffect(ParticleEffects.CRIT, target, new Vector(0.0, 0.3, 0.0), 1.0f, 3, owner.getPlayer());
    }
}

