/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.pets.target;

import de.tobiyas.racesandclasses.pets.SpawnedPet;
import de.tobiyas.racesandclasses.pets.target.Target;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.util.RaC.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class LocationTarget
implements Target {
    private final Location location;

    public LocationTarget(Location location) {
        this.location = location;
    }

    @Override
    public boolean valid(SpawnedPet pet) {
        if (!pet.isSpawned()) {
            return false;
        }
        Location petLocation = pet.getPetEntity().getLocation();
        return petLocation.distanceSquared(this.location) > 1.0;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public Target.TargetType getType() {
        return Target.TargetType.Location;
    }

    @Override
    public void setTarget(LivingEntity pet) {
        VollotileCodeManager.getVollotileCode().entityWalkToLocation(pet, this.location, 1.0);
    }

    @Override
    public void showToOwner(RaCPlayer owner) {
        VollotileCodeManager.getVollotileCode().sendParticleEffect(ParticleEffects.HEART, this.location, new Vector(0.0, 0.3, 0.0), 1.0f, 3, owner.getPlayer());
    }
}

