/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.pets.target;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.pets.SpawnedPet;
import de.tobiyas.racesandclasses.pets.target.Target;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.util.RaC.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;

public class EntityAttackTarget
implements Target {
    private static Set<EntityType> targetWorkingEntities = new HashSet<EntityType>(Arrays.asList(EntityType.WOLF, EntityType.OCELOT));
    private static Set<EntityType> shootingEntities = new HashSet<EntityType>(Arrays.asList(EntityType.SKELETON, EntityType.BLAZE));
    private long lastAttack = 0L;
    private final LivingEntity entity;

    public EntityAttackTarget(LivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public boolean valid(SpawnedPet pet) {
        if (this.entity == null) {
            return false;
        }
        return this.entity.isValid();
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public Target.TargetType getType() {
        return Target.TargetType.Entity;
    }

    @Override
    public void setTarget(LivingEntity pet) {
        if (pet instanceof Creature) {
            Creature petCreature = (Creature)pet;
            EntityType petType = pet.getType();
            if (targetWorkingEntities.contains(petType)) {
                petCreature.setTarget(this.entity);
                return;
            }
            if (shootingEntities.contains(petType)) {
                this.petShootAttack(petCreature);
            } else {
                this.petMeleeAttack(petCreature);
            }
        }
    }

    private void petMeleeAttack(Creature pet) {
        long timeSinceLastAttack;
        double distance = pet.getLocation().distanceSquared(this.entity.getLocation());
        if (distance < 2.0 && (timeSinceLastAttack = System.currentTimeMillis() - this.lastAttack) > 2000L) {
            EntityDamageByEntityEvent event = new EntityDamageByEntityEvent((Entity)pet, (Entity)this.entity, EntityDamageEvent.DamageCause.ENTITY_ATTACK, 1.0);
            RacesAndClasses.getPlugin().fireEventToBukkit((Event)event);
            if (!event.isCancelled()) {
                this.entity.damage(event.getDamage(), (Entity)pet);
                this.lastAttack = System.currentTimeMillis();
            }
        }
        if (distance > 2.0) {
            VollotileCodeManager.getVollotileCode().entityWalkToLocation((LivingEntity)pet, this.entity.getLocation(), 1.0);
        }
    }

    private void petShootAttack(Creature pet) {
        double distance = pet.getLocation().distanceSquared(this.entity.getLocation());
        if (distance > 10.0) {
            VollotileCodeManager.getVollotileCode().entityWalkToLocation((LivingEntity)pet, this.entity.getLocation(), 1.0);
        }
        if (distance < 10.0) {
            VollotileCodeManager.getVollotileCode().entityWalkToLocation((LivingEntity)pet, pet.getLocation(), 1.0);
            Arrow arrow = (Arrow)pet.launchProjectile(Arrow.class);
            arrow.setVelocity(pet.getLocation().toVector().subtract(this.entity.getLocation().toVector()).normalize().multiply(4));
        }
    }

    @Override
    public void showToOwner(RaCPlayer owner) {
        if (!this.entity.isValid()) {
            return;
        }
        Location target = this.entity.getLocation();
        VollotileCodeManager.getVollotileCode().sendParticleEffect(ParticleEffects.HAPPY_VILLAGER, target, new Vector(0.0, 0.3, 0.0), 1.0f, 3, owner.getPlayer());
    }
}

