/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.pets;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.pets.Pet;
import de.tobiyas.racesandclasses.pets.target.EntityAttackTarget;
import de.tobiyas.racesandclasses.pets.target.LocationTarget;
import de.tobiyas.racesandclasses.pets.target.OwnerTarget;
import de.tobiyas.racesandclasses.pets.target.Target;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import java.util.EnumMap;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Tameable;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SpawnedPet {
    private final Pet pet;
    private final RaCPlayer owner;
    private Entity petEntity;
    private final EnumMap<Target.TargetType, Target> targets = new EnumMap(Target.TargetType.class);

    public SpawnedPet(Pet pet, RaCPlayer owner) {
        this.pet = pet;
        this.owner = owner;
        this.targets.put(Target.TargetType.Owner, new OwnerTarget(owner));
    }

    public void despawn() {
        if (this.petEntity != null) {
            this.petEntity.remove();
            this.petEntity.removeMetadata("pet", (Plugin)RacesAndClasses.getPlugin());
        }
        this.petEntity = null;
    }

    public boolean spawnAt(Location location) {
        if (this.petEntity != null) {
            this.despawn();
        }
        this.petEntity = location.getWorld().spawnEntity(location, this.pet.getPetType());
        if (this.petEntity != null) {
            this.petEntity.setMetadata("pet", (MetadataValue)new FixedMetadataValue((Plugin)RacesAndClasses.getPlugin(), (Object)this));
            if (this.petEntity instanceof LivingEntity) {
                LivingEntity livingPet = (LivingEntity)this.petEntity;
                livingPet.setMaxHealth(this.pet.getPetMaxHealth());
            }
            if (this.petEntity instanceof Tameable) {
                Tameable tameable = (Tameable)this.petEntity;
                tameable.setOwner((AnimalTamer)this.owner.getRealPlayer());
            }
            if (this.petEntity instanceof Ageable) {
                Ageable ageable = (Ageable)this.petEntity;
                if (this.pet.isBaby()) {
                    ageable.setBaby();
                } else {
                    ageable.setAdult();
                }
            }
            this.petEntity.setCustomName(this.pet.getPetName());
            this.petEntity.setCustomNameVisible(true);
            this.revalidateTarget();
        }
        return this.petEntity != null && this.petEntity.isValid();
    }

    public Pet getPet() {
        return this.pet;
    }

    public Entity getPetEntity() {
        return this.petEntity;
    }

    public RaCPlayer getOwner() {
        return this.owner;
    }

    public void setCurrentTarget(LivingEntity currentTarget) {
        if (currentTarget == null && this.isSpawned() && this.petEntity instanceof Creature) {
            ((Creature)this.petEntity).setTarget(null);
            return;
        }
        this.targets.put(Target.TargetType.Entity, new EntityAttackTarget(currentTarget));
        this.revalidateTarget();
    }

    public boolean isSpawned() {
        return this.petEntity != null && this.petEntity.isValid();
    }

    public void setNewCurrentTargetLocation(Location newLocation) {
        this.targets.put(Target.TargetType.Location, new LocationTarget(newLocation));
        this.revalidateTarget();
    }

    public void showCurrentTargetToOwner() {
        Target target = this.getTarget();
        if (target != null) {
            target.showToOwner(this.owner);
        }
    }

    public void revalidateTarget() {
        if (!this.isSpawned()) {
            return;
        }
        Target current = this.getTarget();
        if (current != null) {
            current.setTarget((LivingEntity)this.getPetEntity());
        }
    }

    public Target getTarget() {
        if (!this.isSpawned()) {
            return null;
        }
        for (Target target : new HashSet<Target>(this.targets.values())) {
            if (target.valid(this)) continue;
            this.targets.remove((Object)target.getType());
        }
        int prio = 0;
        Target current = null;
        for (Target target : new HashSet<Target>(this.targets.values())) {
            if (target.getPriority() <= prio) continue;
            current = target;
            prio = target.getPriority();
        }
        return current;
    }

    public double getDistanceToOwner() {
        if (!this.owner.isOnline()) {
            return Double.MAX_VALUE;
        }
        if (!this.isSpawned()) {
            return Double.MAX_VALUE;
        }
        if (this.owner.getWorld() != this.petEntity.getWorld()) {
            return Double.MAX_VALUE;
        }
        return this.owner.getLocation().distance(this.petEntity.getLocation());
    }
}

