/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.pets;

import de.tobiyas.racesandclasses.pets.Pet;
import de.tobiyas.racesandclasses.pets.SpawnedPet;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.util.location.LocationOffsetUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;

public class PlayerPetManager {
    private final Set<SpawnedPet> spawnedPets = new HashSet<SpawnedPet>();
    private final RaCPlayer owner;

    public PlayerPetManager(RaCPlayer player) {
        this.owner = player;
    }

    public void tick() {
        if (!this.owner.isOnline()) {
            this.despawnAndClear();
            return;
        }
        Location ownerLocation = this.owner.getLocation();
        for (SpawnedPet pet : this.spawnedPets) {
            boolean revive;
            double distToOwner = pet.getDistanceToOwner();
            boolean bl = revive = !pet.isSpawned() && pet.getPet().isAutoRevive();
            if (revive || distToOwner > 50.0) {
                pet.despawn();
                pet.spawnAt(LocationOffsetUtils.getRandomAround(ownerLocation));
                continue;
            }
            pet.revalidateTarget();
            pet.showCurrentTargetToOwner();
        }
    }

    public void despawnAndClear() {
        for (SpawnedPet pet : this.spawnedPets) {
            pet.despawn();
        }
        this.spawnedPets.clear();
    }

    public void playerGotTargeted(LivingEntity entity) {
        for (SpawnedPet pet : this.spawnedPets) {
            pet.setCurrentTarget(entity);
        }
    }

    public void playerGotDamaged(LivingEntity entity) {
        for (SpawnedPet pet : this.spawnedPets) {
            pet.setCurrentTarget(entity);
        }
    }

    public void playerAttacks(LivingEntity entity) {
        for (SpawnedPet pet : this.spawnedPets) {
            pet.setCurrentTarget(entity);
        }
    }

    public void registerNewPet(Pet pet) {
        SpawnedPet newPet = new SpawnedPet(pet, this.owner);
        this.spawnedPets.add(newPet);
    }

    public void removePet(Pet pet) {
        for (SpawnedPet spawned : this.spawnedPets) {
            if (spawned.getPet() != pet) continue;
            this.spawnedPets.remove(pet);
            return;
        }
    }

    public void revivePet(Pet pet, Location location) {
        for (SpawnedPet spawned : this.spawnedPets) {
            if (spawned.getPet() != pet) continue;
            spawned.spawnAt(location);
        }
    }

    public SpawnedPet getSpawnedPet(Pet pet) {
        for (SpawnedPet spawned : this.spawnedPets) {
            if (spawned.getPet() != pet) continue;
            return spawned;
        }
        return null;
    }

    public Collection<Pet> getRegisteredPets() {
        HashSet<Pet> pets = new HashSet<Pet>();
        for (SpawnedPet pet : this.spawnedPets) {
            pets.add(pet.getPet());
        }
        return pets;
    }

    public Collection<SpawnedPet> getSpawnedPets() {
        return new HashSet<SpawnedPet>(this.spawnedPets);
    }
}

