/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.pets;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.pets.PlayerPetManager;
import de.tobiyas.racesandclasses.pets.SpawnedPet;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PetListener
implements Listener {
    private final RacesAndClasses plugin;

    public PetListener(RacesAndClasses plugin) {
        this.plugin = plugin;
        this.plugin.registerEvents(this);
    }

    @EventHandler
    public void onPetDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!entity.hasMetadata("pet")) {
            return;
        }
        SpawnedPet petContainer = (SpawnedPet)((MetadataValue)entity.getMetadata("pet").get(0)).value();
        if (petContainer.getPet().isInvincible()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void passivePetsDontTarget(EntityTargetEvent event) {
        SpawnedPet petContainer;
        Entity entity = event.getEntity();
        if (entity != null) {
            if (!entity.hasMetadata("pet")) {
                return;
            }
            petContainer = (SpawnedPet)((MetadataValue)entity.getMetadata("pet").get(0)).value();
            if (petContainer.getPet().isPassive()) {
                event.setCancelled(true);
            }
        }
        if ((entity = event.getTarget()) != null) {
            if (!entity.hasMetadata("pet")) {
                return;
            }
            petContainer = (SpawnedPet)((MetadataValue)entity.getMetadata("pet").get(0)).value();
            if (petContainer.getPet().isPassive()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPetDealingDamage(EntityDamageByEntityEvent event) {
        Entity damagee = event.getEntity();
        UUID entityID = damagee.getUniqueId();
        Entity damager = event.getDamager();
        if (damager != null) {
            if (!damager.hasMetadata("pet")) {
                return;
            }
            SpawnedPet petContainer = (SpawnedPet)((MetadataValue)damager.getMetadata("pet").get(0)).value();
            if (petContainer.getOwner().getUniqueId().equals(entityID)) {
                event.setCancelled(true);
                return;
            }
            if (!petContainer.getPet().isPassive()) {
                event.setDamage(petContainer.getPet().getPetDamage());
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void ownerIsGettingTargeted(EntityTargetEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        Entity target = event.getTarget();
        if (target == null) {
            return;
        }
        if (target.getType() != EntityType.PLAYER) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer((Player)target);
        PlayerPetManager petManager = player.getPlayerPetManager();
        petManager.playerGotTargeted((LivingEntity)event.getEntity());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void cancelPetTargetOwner(EntityTargetEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        Entity target = event.getTarget();
        if (target == null) {
            return;
        }
        if (target.getType() != EntityType.PLAYER) {
            return;
        }
        if (!event.getEntity().hasMetadata("pet")) {
            return;
        }
        SpawnedPet pet = (SpawnedPet)((MetadataValue)event.getEntity().getMetadata("pet").get(0)).value();
        if (target.getUniqueId().equals(pet.getOwner().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void ownerIsGettingAttacked(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity damagee = event.getEntity();
        if (damagee == null) {
            return;
        }
        if (damagee.getType() != EntityType.PLAYER) {
            return;
        }
        Entity damager = event.getDamager();
        if (damager == null) {
            return;
        }
        if (!(damager instanceof LivingEntity)) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer((Player)damagee);
        PlayerPetManager petManager = player.getPlayerPetManager();
        petManager.playerGotDamaged((LivingEntity)event.getEntity());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPetDied(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (!entity.hasMetadata("pet")) {
            return;
        }
        entity.removeMetadata("pet", (Plugin)this.plugin);
        event.getDrops().clear();
        event.setDroppedExp(0);
    }

    @EventHandler
    public void onOnwerAttacks(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        Entity damagee = event.getEntity();
        if (damager == null || damagee == null) {
            return;
        }
        if (!(damagee instanceof LivingEntity)) {
            return;
        }
        if (damager.getType() != EntityType.PLAYER) {
            return;
        }
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(damager.getUniqueId());
        racPlayer.getPlayerPetManager().playerAttacks((LivingEntity)damagee);
    }

    @EventHandler
    public void petsDoNotBurn(EntityCombustEvent event) {
        if (event.getEntity().hasMetadata("pet")) {
            event.setCancelled(true);
        }
    }
}

