/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.racechangelistener;

import de.tobiyas.racesandclasses.APIs.ClassAPI;
import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.configuration.global.GeneralConfig;
import de.tobiyas.racesandclasses.cooldown.CooldownManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.HolderSelectionPreconditions;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.raceevent.AfterRaceChangedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.raceevent.AfterRaceSelectedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.raceevent.PreRaceSelectEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class RaceChangeSelectionListener
implements Listener {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private CooldownManager cooldownManager = this.plugin.getCooldownManager();

    public RaceChangeSelectionListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void checkPlayerhasPermissionToRace(PreRaceSelectEvent event) {
        if (event.getRaceToSelect() == this.plugin.getRaceManager().getDefaultHolder()) {
            return;
        }
        if (!event.isCheckPermissions()) {
            return;
        }
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_usePermissionsForRaces()) {
            RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
            String raceName = event.getRaceToSelect().getDisplayName();
            String permissionNode = "RaC.races." + raceName;
            if (!this.plugin.getPermissionManager().checkPermissionsSilent((CommandSender)player.getPlayer(), permissionNode)) {
                event.setCancelled("You do not have the Permission to select the Race" + raceName);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void checkClassHasPermissionForRace(PreRaceSelectEvent event) {
        if (event.getRaceToSelect() == this.plugin.getClassManager().getDefaultHolder()) {
            return;
        }
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_useRaceClassSelectionMatrix()) {
            RaCPlayer playerSelecting = RaCPlayerManager.get().getPlayer(event.getPlayer());
            String raceName = event.getRaceToSelect().getDisplayName();
            ClassContainer holder = playerSelecting.getclass();
            if (holder == null) {
                return;
            }
            String className = holder.getDisplayName();
            boolean valid = this.plugin.getConfigManager().getRaceToClassConfig().isValidCombination(raceName, className);
            if (!valid) {
                event.setCancelled("Your class can not select the race: " + raceName);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void checkPlayerMeetsPreconditions(PreRaceSelectEvent event) {
        HolderSelectionPreconditions.HolderPreconditionResult result;
        Player player = event.getPlayer();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        AbstractTraitHolder newHolder = event.getHolderToSelect();
        if (newHolder != null && (result = newHolder.getPreconditions().checkPreconditions(racPlayer)) != HolderSelectionPreconditions.HolderPreconditionResult.RESTRICTIONS_MET) {
            String translated = LanguageAPI.translate(racPlayer, result.name().toLowerCase(), "HOLDER", "Specific Race");
            event.setCancelled(translated);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void checkPlayerHasUplinkOnChange(PreRaceSelectEvent event) {
        String commandName;
        if (!event.isCheckCooldown()) {
            return;
        }
        String playerName = event.getPlayer().getName();
        int remainingCooldown = this.cooldownManager.stillHasCooldown(playerName, commandName = "racechange");
        if (remainingCooldown > 0) {
            String message = ChatColor.RED + "You still have " + ChatColor.LIGHT_PURPLE + remainingCooldown + ChatColor.RED + " seconds cooldown on that command";
            event.setCancelled(message);
        }
    }

    @EventHandler
    public void givePlayerUplinkAfterSelect(AfterRaceSelectedEvent event) {
        if (!event.isGiveCooldown()) {
            return;
        }
        if (event.getRaceToSelect() == this.plugin.getRaceManager().getDefaultHolder()) {
            return;
        }
        String playerName = event.getPlayer().getName();
        String commandName = "racechange";
        int time = this.plugin.getConfigManager().getGeneralConfig().getConfig_raceChangeCommandUplink();
        this.cooldownManager.setCooldown(playerName, commandName, time);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void rescanHP(AfterRaceSelectedEvent selectEvent) {
        if (selectEvent.getPlayer() == null) {
            return;
        }
        if (selectEvent.getPlayer().getName() == null) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(selectEvent.getPlayer());
        this.plugin.getPlayerManager().getContainer(player).rescan();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void sendCommandAfterChange(AfterRaceChangedEvent event) {
        RaceContainer old = event.getOldRace();
        if (old != null) {
            this.executeCommands(RaCPlayerManager.get().getPlayer(event.getPlayer()), old.getCommandExecuteOnExit(), old);
        }
        this.sendCommandAfterSelect(event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void sendCommandAfterSelect(AfterRaceSelectedEvent selectEvent) {
        if (selectEvent.getPlayer() == null) {
            return;
        }
        if (selectEvent.getPlayer().getName() == null) {
            return;
        }
        List<String> commands = this.plugin.getConfigManager().getGeneralConfig().getConfig_race_commands_after_change();
        if (selectEvent.getHolderToSelect() != null) {
            commands.addAll(selectEvent.getHolderToSelect().getCommandExecuteOnJoin());
        }
        if (commands.isEmpty()) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(selectEvent.getPlayer());
        this.executeCommands(player, commands, selectEvent.getRaceToSelect());
    }

    private void executeCommands(RaCPlayer player, Collection<String> commands, RaceContainer toUse) {
        if (player == null) {
            return;
        }
        for (String command : commands) {
            if (command == null || command.isEmpty()) continue;
            boolean asConsole = command.contains("%CONSOLE%");
            boolean asOp = command.contains("%OP%");
            command = command.startsWith("/") ? command.substring(1) : command;
            command = command.replace("%CONSOLE%", "");
            command = command.replace("%OP%", "");
            command = command.replace("%CLASS%", this.OrEmpty(ClassAPI.getClassNameOfPlayer(player.getPlayer())));
            command = command.replace("%RACE%", this.OrEmpty(toUse.getDisplayName()));
            command = command.replace("%PLAYER%", player.getName());
            command = command.replace("%DISPLAY%", player.getDisplayName());
            boolean opBefore = player.getPlayer().isOp();
            if (asOp && !asConsole) {
                player.getPlayer().setOp(true);
            }
            try {
                try {
                    if (asConsole) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                    } else {
                        player.getPlayer().chat("/" + command);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!asOp || asConsole || opBefore) continue;
                    player.getPlayer().setOp(false);
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (asOp && !asConsole && !opBefore) {
                    player.getPlayer().setOp(false);
                }
                throw throwable;
            }
            if (!asOp || asConsole || opBefore) continue;
            player.getPlayer().setOp(false);
        }
    }

    private String OrEmpty(String value) {
        return value == null ? "" : value;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void removeClassAfterChange(AfterRaceChangedEvent event) {
        this.sendCommandAfterSelect(event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void removeClassAfterChange(AfterRaceSelectedEvent selectEvent) {
        GeneralConfig config = this.plugin.getConfigManager().getGeneralConfig();
        if (!config.isConfig_classes_removeClassOnRaceChange()) {
            return;
        }
        if (!config.isConfig_enableRaces()) {
            return;
        }
        if (!config.isConfig_classes_enable()) {
            return;
        }
        String defaultClass = ClassAPI.getDefaultClassName();
        ClassAPI.addPlayerToClass(selectEvent.getPlayer(), defaultClass);
    }
}

