/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.npc;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.configuration.global.GeneralConfig;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.gui.HolderInventory;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.PreClassSelectEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.raceevent.PreRaceSelectEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;

public class Listener_NPCInteract
implements Listener {
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public Listener_NPCInteract() {
        if (Bukkit.getPluginManager().getPlugin("Citizens") != null) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
    }

    @EventHandler
    public void playerInteractNPCEvent(NPCRightClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        String npcName = event.getNPC().getFullName();
        Player player = event.getClicker();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        GeneralConfig config = this.plugin.getConfigManager().getGeneralConfig();
        if (config.getConfig_npc_select_race().contains(npcName)) {
            RaceContainer currentRace = racPlayer.getRace();
            if (currentRace != this.plugin.getRaceManager().getDefaultHolder()) {
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "already_have_race", "race", currentRace.getDisplayName());
                return;
            }
            PreRaceSelectEvent ccEvent = new PreRaceSelectEvent(player, (RaceContainer)this.plugin.getRaceManager().getDefaultHolder());
            this.plugin.getServer().getPluginManager().callEvent((Event)ccEvent);
            if (ccEvent.isCancelled()) {
                player.sendMessage(ChatColor.RED + "[RaC] + " + ccEvent.getCancelMessage());
                return;
            }
            HolderInventory holderInventory = new HolderInventory(player, this.plugin.getRaceManager());
            if (holderInventory.getNumberOfHolder() <= 0) {
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "no_race_to_select");
                return;
            }
            player.openInventory((InventoryView)holderInventory);
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "open_holder", "holder", "Race");
            return;
        }
        if (config.getConfig_npc_change_race().contains(npcName)) {
            RaceContainer currentRace = racPlayer.getRace();
            if (currentRace == this.plugin.getRaceManager().getDefaultHolder()) {
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "no_race_selected");
                return;
            }
            PreRaceSelectEvent ccEvent = new PreRaceSelectEvent(player, (RaceContainer)this.plugin.getRaceManager().getDefaultHolder());
            this.plugin.getServer().getPluginManager().callEvent((Event)ccEvent);
            if (ccEvent.isCancelled()) {
                player.sendMessage(ChatColor.RED + "[RaC] + " + ccEvent.getCancelMessage());
                return;
            }
            HolderInventory holderInventory = new HolderInventory(player, this.plugin.getRaceManager());
            if (holderInventory.getNumberOfHolder() <= 0) {
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "no_race_to_select");
                return;
            }
            player.openInventory((InventoryView)holderInventory);
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "open_holder", "holder", "Race");
            return;
        }
        if (config.getConfig_npc_select_class().contains(npcName)) {
            ClassContainer currentClass = racPlayer.getclass();
            if (currentClass != this.plugin.getClassManager().getDefaultHolder()) {
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "already_have_class", "clasname", currentClass.getDisplayName());
                return;
            }
            PreClassSelectEvent ccEvent = new PreClassSelectEvent(player, (ClassContainer)this.plugin.getClassManager().getDefaultHolder());
            this.plugin.getServer().getPluginManager().callEvent((Event)ccEvent);
            if (ccEvent.isCancelled()) {
                player.sendMessage(ChatColor.RED + "[RaC] + " + ccEvent.getCancelMessage());
                return;
            }
            HolderInventory holderInventory = new HolderInventory(player, this.plugin.getClassManager());
            if (holderInventory.getNumberOfHolder() <= 0) {
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "no_class_to_select");
                return;
            }
            player.openInventory((InventoryView)holderInventory);
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "open_holder", "holder", "Class");
            return;
        }
        if (config.getConfig_npc_change_class().contains(npcName)) {
            ClassContainer currentClass = racPlayer.getclass();
            if (currentClass == this.plugin.getClassManager().getDefaultHolder()) {
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "no_class_on_change");
                return;
            }
            PreClassSelectEvent ccEvent = new PreClassSelectEvent(player, (ClassContainer)this.plugin.getClassManager().getDefaultHolder());
            this.plugin.getServer().getPluginManager().callEvent((Event)ccEvent);
            if (ccEvent.isCancelled()) {
                player.sendMessage(ChatColor.RED + "[RaC] + " + ccEvent.getCancelMessage());
                return;
            }
            HolderInventory holderInventory = new HolderInventory(player, this.plugin.getClassManager());
            if (holderInventory.getNumberOfHolder() <= 0) {
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "no_class_to_select");
                return;
            }
            player.openInventory((InventoryView)holderInventory);
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "open_holder", "holder", "Class");
            return;
        }
    }
}

